/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import retrofit2.Converter;
import retrofit2.ParameterHandler;
import retrofit2.Retrofit;
import retrofit2.http.ParamHeaders;
import retrofit2.http.ParamQuerys;
import retrofit2.http.ParamUrl;

public class ServiceParser {
    static ParameterHandler[] parseClassAnnotations(Class service, Retrofit retrofit) {
        Annotation[] annotations;
        ArrayList requestActions = new ArrayList();
        for (Annotation annotation : annotations = service.getAnnotations()) {
            ParameterHandler action;
            Converter valueConverter;
            String name;
            int i;
            if (annotation instanceof ParamHeaders) {
                ParamHeaders headers = (ParamHeaders)annotation;
                String[] headerStrings = headers.value();
                if (headerStrings.length == 0) {
                    throw ServiceParser.typeError(service, "@Headers annotation is empty.", new Object[0]);
                }
                for (i = 0; i < headerStrings.length; ++i) {
                    name = headerStrings[i];
                    valueConverter = retrofit.stringConverter((Type)((Object)String.class), new Annotation[]{annotation});
                    action = new ParameterHandler.ParamHeader(name, valueConverter);
                    requestActions.add(action);
                }
                continue;
            }
            if (annotation instanceof ParamQuerys) {
                ParamQuerys querys = (ParamQuerys)annotation;
                String[] queryStrings = querys.value();
                if (queryStrings.length == 0) {
                    throw ServiceParser.typeError(service, "@ParamQuerys annotation is empty.", new Object[0]);
                }
                for (i = 0; i < queryStrings.length; ++i) {
                    name = queryStrings[i];
                    valueConverter = retrofit.stringConverter((Type)((Object)String.class), new Annotation[]{annotation});
                    action = new ParameterHandler.ParamQuery(name, valueConverter, querys.encoded());
                    requestActions.add(action);
                }
                continue;
            }
            if (!(annotation instanceof ParamUrl)) continue;
            ParamUrl baseUrl = (ParamUrl)annotation;
            String value = baseUrl.value();
            action = new ParameterHandler.ParamUrl(value);
            requestActions.add(action);
        }
        return requestActions.toArray(new ParameterHandler[requestActions.size()]);
    }

    static RuntimeException typeError(Type type, String message, Object ... args) {
        message = String.format(message, args);
        IllegalArgumentException e = new IllegalArgumentException(message + "\n    for Type " + type.toString());
        e.initCause(null);
        return e;
    }
}

