/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import okhttp3.CacheControl;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import retrofit2.Converter;

final class RequestBuilder {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String PATH_SEGMENT_ALWAYS_ENCODE_SET = " \"<>^`{}|\\?#";
    private static final Pattern PATH_TRAVERSAL = Pattern.compile("(.*/)?(\\.|%2e|%2E){1,2}(/.*)?");
    private final String method;
    private final HttpUrl baseUrl;
    private String serviceUrl;
    @Nullable
    private String relativeUrl;
    @Nullable
    private HttpUrl.Builder urlBuilder;
    private final Request.Builder requestBuilder;
    private final Headers.Builder headersBuilder;
    @Nullable
    private MediaType contentType;
    private final boolean hasBody;
    @Nullable
    private MultipartBody.Builder multipartBuilder;
    @Nullable
    private FormBody.Builder formBuilder;
    @Nullable
    private Converter<Object, RequestBody> requestBodyConverter;
    @Nullable
    private RequestBody body;

    RequestBuilder(String method, HttpUrl baseUrl, @Nullable String relativeUrl, @Nullable Headers headers, @Nullable MediaType contentType, boolean hasBody, Converter<Object, RequestBody> requestBodyConverter, boolean isFormEncoded, boolean isMultipart) {
        this.method = method;
        this.baseUrl = baseUrl;
        this.relativeUrl = relativeUrl;
        this.requestBuilder = new Request.Builder();
        this.contentType = contentType;
        this.hasBody = hasBody;
        this.headersBuilder = headers != null ? headers.newBuilder() : new Headers.Builder();
        this.requestBodyConverter = requestBodyConverter;
        if (isFormEncoded) {
            this.formBuilder = new FormBody.Builder();
        } else if (isMultipart) {
            this.multipartBuilder = new MultipartBody.Builder();
            this.multipartBuilder.setType(MultipartBody.FORM);
        }
    }

    void setRelativeUrl(Object relativeUrl) {
        this.relativeUrl = relativeUrl.toString();
    }

    void addHeader(String name, String value) {
        if ("Content-Type".equalsIgnoreCase(name)) {
            try {
                this.contentType = MediaType.get((String)value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Malformed content type: " + value, e);
            }
        } else {
            this.headersBuilder.add(name, value);
        }
    }

    void addHeaders(Headers headers) {
        this.headersBuilder.addAll(headers);
    }

    public void cacheControl(CacheControl cacheControl) {
        this.headersBuilder.set("Cache-Control", cacheControl.toString());
        String value = cacheControl.toString();
        if (value.isEmpty()) {
            this.headersBuilder.removeAll("Cache-Control");
        } else {
            this.headersBuilder.set("Cache-Control", value);
        }
    }

    void addPathParam(String name, String value, boolean encoded) {
        if (this.relativeUrl == null) {
            throw new AssertionError((Object)("The current request has an error while add the path :" + name + "=" + value));
        }
        String replacement = RequestBuilder.canonicalizeForPath(value, encoded);
        String newRelativeUrl = this.relativeUrl.replace("{" + name + "}", replacement);
        if (PATH_TRAVERSAL.matcher(newRelativeUrl).matches()) {
            throw new IllegalArgumentException("@Path parameters shouldn't perform path traversal ('.' or '..'): " + value);
        }
        this.relativeUrl = newRelativeUrl;
    }

    private static String canonicalizeForPath(String input, boolean alreadyEncoded) {
        int codePoint;
        int limit = input.length();
        for (int i = 0; i < limit; i += Character.charCount(codePoint)) {
            codePoint = input.codePointAt(i);
            if (codePoint >= 32 && codePoint < 127 && PATH_SEGMENT_ALWAYS_ENCODE_SET.indexOf(codePoint) == -1 && (alreadyEncoded || codePoint != 47 && codePoint != 37)) continue;
            Buffer out = new Buffer();
            out.writeUtf8(input, 0, i);
            RequestBuilder.canonicalizeForPath(out, input, i, limit, alreadyEncoded);
            return out.readUtf8();
        }
        return input;
    }

    private static void canonicalizeForPath(Buffer out, String input, int pos, int limit, boolean alreadyEncoded) {
        int codePoint;
        Buffer utf8Buffer = null;
        for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
            codePoint = input.codePointAt(i);
            if (alreadyEncoded && (codePoint == 9 || codePoint == 10 || codePoint == 12 || codePoint == 13)) continue;
            if (codePoint < 32 || codePoint >= 127 || PATH_SEGMENT_ALWAYS_ENCODE_SET.indexOf(codePoint) != -1 || !alreadyEncoded && (codePoint == 47 || codePoint == 37)) {
                if (utf8Buffer == null) {
                    utf8Buffer = new Buffer();
                }
                utf8Buffer.writeUtf8CodePoint(codePoint);
                while (!utf8Buffer.exhausted()) {
                    int b = utf8Buffer.readByte() & 0xFF;
                    out.writeByte(37);
                    out.writeByte((int)HEX_DIGITS[b >> 4 & 0xF]);
                    out.writeByte((int)HEX_DIGITS[b & 0xF]);
                }
                continue;
            }
            out.writeUtf8CodePoint(codePoint);
        }
    }

    void addQueryParam(String name, @Nullable String value, boolean encoded) {
        if (this.urlBuilder == null) {
            this.buildHttpUrl();
        }
        if (encoded) {
            this.urlBuilder.addEncodedQueryParameter(name, value);
        } else {
            this.urlBuilder.addQueryParameter(name, value);
        }
    }

    void addFormField(String name, String value, boolean encoded) {
        if (encoded) {
            this.formBuilder.addEncoded(name, value);
        } else {
            this.formBuilder.add(name, value);
        }
    }

    void addPart(Headers headers, RequestBody body) {
        this.multipartBuilder.addPart(headers, body);
    }

    void addPart(MultipartBody.Part part) {
        this.multipartBuilder.addPart(part);
    }

    void setBody(RequestBody body) {
        this.body = body;
    }

    <T> void addTag(Class<T> cls, @Nullable T value) {
        this.requestBuilder.tag(cls, value);
    }

    Request.Builder get() throws IOException {
        MediaType contentType;
        HttpUrl url = this.buildHttpUrl();
        RequestBody body = this.body;
        if (body == null) {
            if (this.formBuilder != null) {
                body = this.formBuilder.build();
            } else if (this.multipartBuilder != null) {
                body = this.multipartBuilder.build();
            } else if (this.hasBody) {
                body = RequestBody.create(null, (byte[])new byte[0]);
            }
        }
        if ((contentType = this.contentType) != null) {
            if (body != null) {
                if (this.requestBodyConverter != null) {
                    body = this.requestBodyConverter.convert(body);
                }
                body = new ContentTypeOverridingRequestBody(body, contentType);
            } else {
                this.headersBuilder.add("Content-Type", contentType.toString());
            }
        }
        return this.requestBuilder.url(url).headers(this.headersBuilder.build()).method(this.method, body);
    }

    private HttpUrl buildHttpUrl() {
        HttpUrl url;
        if (this.urlBuilder == null) {
            url = this.baseUrl;
            if (this.serviceUrl != null) {
                if ((url = url.resolve(this.serviceUrl)) == null) {
                    url = HttpUrl.get((String)this.serviceUrl);
                }
                this.serviceUrl = null;
            }
            if (this.relativeUrl != null) {
                if ((url = url.resolve(this.relativeUrl)) == null) {
                    throw new IllegalArgumentException("Malformed URL. Base: " + this.baseUrl + ", Relative: " + this.relativeUrl);
                }
                this.relativeUrl = null;
            }
            this.urlBuilder = url.newBuilder();
        } else {
            url = this.urlBuilder.build();
        }
        return url;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    private static class ContentTypeOverridingRequestBody
    extends RequestBody {
        private final RequestBody delegate;
        private final MediaType contentType;

        ContentTypeOverridingRequestBody(RequestBody delegate, MediaType contentType) {
            this.delegate = delegate;
            this.contentType = contentType;
        }

        public MediaType contentType() {
            return this.contentType;
        }

        public long contentLength() throws IOException {
            return this.delegate.contentLength();
        }

        public void writeTo(BufferedSink sink) throws IOException {
            this.delegate.writeTo(sink);
        }
    }
}

