/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import okhttp3.CacheControl;
import okhttp3.Request;
import okio.Timeout;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.SkipCallbackExecutor;
import retrofit2.Utils;

final class DefaultCallAdapterFactory
extends CallAdapter.Factory {
    @Nullable
    private final Executor callbackExecutor;

    DefaultCallAdapterFactory(@Nullable Executor callbackExecutor) {
        this.callbackExecutor = callbackExecutor;
    }

    @Override
    @Nullable
    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        if (DefaultCallAdapterFactory.getRawType(returnType) != Call.class) {
            return null;
        }
        if (!(returnType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Call return type must be parameterized as Call<Foo> or Call<? extends Foo>");
        }
        final Type responseType = Utils.getParameterUpperBound(0, (ParameterizedType)returnType);
        final Executor executor = Utils.isAnnotationPresent(annotations, SkipCallbackExecutor.class) ? null : this.callbackExecutor;
        return new CallAdapter<Object, Call<?>>(){

            @Override
            public Type responseType() {
                return responseType;
            }

            @Override
            public Call<Object> adapt(Call<Object> call) {
                return executor == null ? call : new ExecutorCallbackCall(executor, call);
            }
        };
    }

    static final class ExecutorCallbackCall<T>
    implements Call<T> {
        final Executor callbackExecutor;
        final Call<T> delegate;

        ExecutorCallbackCall(Executor callbackExecutor, Call<T> delegate) {
            this.callbackExecutor = callbackExecutor;
            this.delegate = delegate;
        }

        @Override
        public void enqueue(Callback<T> callback) {
            this.enqueue(callback, null);
        }

        @Override
        public void enqueue(final Callback<T> callback, CacheControl cacheControl) {
            Objects.requireNonNull(callback, "callback == null");
            this.delegate.enqueue(new Callback<T>(){

                @Override
                public void onResponse(Call<T> call, Response<T> response) {
                    callbackExecutor.execute(() -> {
                        if (delegate.isCanceled()) {
                            callback.onFailure(this, new IOException("Canceled"));
                        } else {
                            callback.onResponse(this, response);
                        }
                    });
                }

                @Override
                public void onFailure(Call<T> call, Throwable t) {
                    callbackExecutor.execute(() -> callback.onFailure(this, t));
                }
            }, cacheControl);
        }

        @Override
        public boolean isExecuted() {
            return this.delegate.isExecuted();
        }

        @Override
        public Response<T> execute() throws IOException {
            return this.delegate.execute();
        }

        @Override
        public Response<T> execute(CacheControl cacheControl) throws IOException {
            return this.delegate.execute(cacheControl);
        }

        @Override
        public void cancel() {
            this.delegate.cancel();
        }

        @Override
        public boolean isCanceled() {
            return this.delegate.isCanceled();
        }

        @Override
        public Call<T> clone() {
            return new ExecutorCallbackCall<T>(this.callbackExecutor, this.delegate.clone());
        }

        @Override
        public Request request() {
            return this.delegate.request();
        }

        @Override
        public Timeout timeout() {
            return this.delegate.timeout();
        }
    }
}

