/*
 * Decompiled with CFR 0.152.
 */
package io.github.thoroldvix.internal;

import io.github.thoroldvix.api.TranscriptRetrievalException;
import io.github.thoroldvix.api.YoutubeClient;
import io.github.thoroldvix.api.YtApiV3Endpoint;
import io.github.thoroldvix.internal.YoutubeApiResponseParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class YoutubeApi {
    private final YoutubeClient client;

    YoutubeApi(YoutubeClient client) {
        this.client = client;
    }

    String getChannelPlaylistId(String channelName, String apiKey) throws TranscriptRetrievalException {
        String channelId = this.getChannelId(channelName, apiKey);
        Map<String, String> params = this.createParams("key", apiKey, "part", "contentDetails", "id", channelId);
        String channelJson = this.client.get(YtApiV3Endpoint.CHANNELS, params);
        return YoutubeApiResponseParser.getChannelPlaylistId(channelJson);
    }

    List<String> getVideoIds(String playlistId, String apiKey) throws TranscriptRetrievalException {
        Map<String, String> params = this.createParams("key", apiKey, "playlistId", playlistId, "part", "snippet", "maxResults", "50");
        ArrayList<String> videoIds = new ArrayList<String>();
        while (true) {
            String playlistJson = this.client.get(YtApiV3Endpoint.PLAYLIST_ITEMS, params);
            videoIds.addAll(YoutubeApiResponseParser.getVideoIds(playlistJson));
            String nextPageToken = YoutubeApiResponseParser.getNextPageToken(playlistJson);
            if (nextPageToken == null) break;
            params.put("pageToken", nextPageToken);
        }
        return videoIds;
    }

    private String getChannelId(String channelName, String apiKey) throws TranscriptRetrievalException {
        Map<String, String> params = this.createParams("key", apiKey, "q", channelName, "part", "snippet", "type", "channel");
        String searchJson = this.client.get(YtApiV3Endpoint.SEARCH, params);
        return YoutubeApiResponseParser.getChannelId(searchJson, channelName);
    }

    private Map<String, String> createParams(String ... params) {
        HashMap<String, String> map = new HashMap<String, String>(params.length / 2);
        for (int i = 0; i < params.length; i += 2) {
            map.put(params[i], params[i + 1]);
        }
        return map;
    }
}

