/*
 * Decompiled with CFR 0.152.
 */
package io.github.thoroldvix.internal;

import io.github.thoroldvix.api.TranscriptContent;
import io.github.thoroldvix.api.TranscriptList;
import io.github.thoroldvix.api.TranscriptRequest;
import io.github.thoroldvix.api.TranscriptRetrievalException;
import io.github.thoroldvix.api.YoutubeClient;
import io.github.thoroldvix.api.YoutubeTranscriptApi;
import io.github.thoroldvix.internal.FileLinesReader;
import io.github.thoroldvix.internal.TranscriptListExtractor;
import io.github.thoroldvix.internal.VideoPageFetcher;
import io.github.thoroldvix.internal.YoutubeApi;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

final class DefaultYoutubeTranscriptApi
implements YoutubeTranscriptApi {
    private final VideoPageFetcher videoPageFetcher;
    private final YoutubeApi youtubeApi;
    private final YoutubeClient client;

    DefaultYoutubeTranscriptApi(YoutubeClient client, FileLinesReader fileLinesReader) {
        this.videoPageFetcher = new VideoPageFetcher(client, fileLinesReader);
        this.youtubeApi = new YoutubeApi(client);
        this.client = client;
    }

    private static TranscriptContent transcriptContentSupplier(TranscriptRequest request, String[] languageCodes, TranscriptList transcriptList) {
        try {
            return transcriptList.findTranscript(languageCodes).fetch();
        }
        catch (TranscriptRetrievalException e) {
            if (request.isStopOnError()) {
                throw new CompletionException(e);
            }
            return null;
        }
    }

    private static void joinFutures(List<CompletableFuture<Void>> futures, String playlistId) throws TranscriptRetrievalException {
        try {
            CompletableFuture<Void> allOf = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            allOf.join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof TranscriptRetrievalException) {
                throw (TranscriptRetrievalException)e.getCause();
            }
            throw new TranscriptRetrievalException("Failed to retrieve transcripts for playlist: " + playlistId, e);
        }
    }

    @Override
    public TranscriptContent getTranscriptWithCookies(String videoId, String cookiesPath, String ... languageCodes) throws TranscriptRetrievalException {
        return this.listTranscriptsWithCookies(videoId, cookiesPath).findTranscript(languageCodes).fetch();
    }

    @Override
    public TranscriptContent getTranscript(String videoId, String ... languageCodes) throws TranscriptRetrievalException {
        return this.listTranscripts(videoId).findTranscript(languageCodes).fetch();
    }

    @Override
    public TranscriptList listTranscriptsWithCookies(String videoId, String cookiesPath) throws TranscriptRetrievalException {
        this.validateVideoId(videoId);
        TranscriptListExtractor extractor = new TranscriptListExtractor(this.client, videoId);
        String videoPageHtml = this.videoPageFetcher.fetch(videoId, cookiesPath);
        return extractor.extract(videoPageHtml);
    }

    @Override
    public TranscriptList listTranscripts(String videoId) throws TranscriptRetrievalException {
        this.validateVideoId(videoId);
        TranscriptListExtractor extractor = new TranscriptListExtractor(this.client, videoId);
        String videoPageHtml = this.videoPageFetcher.fetch(videoId);
        return extractor.extract(videoPageHtml);
    }

    @Override
    public Map<String, TranscriptList> listTranscriptsForPlaylist(String playlistId, TranscriptRequest request) throws TranscriptRetrievalException {
        ConcurrentHashMap<String, TranscriptList> transcriptLists = new ConcurrentHashMap<String, TranscriptList>();
        List<String> videoIds = this.youtubeApi.getVideoIds(playlistId, request.getApiKey());
        List<CompletableFuture<Void>> futures = videoIds.stream().map(videoId -> CompletableFuture.supplyAsync(() -> this.transcriptListSupplier(request, (String)videoId)).thenAccept(transcriptList -> {
            if (transcriptList != null) {
                transcriptLists.put(transcriptList.getVideoId(), (TranscriptList)transcriptList);
            }
        })).collect(Collectors.toList());
        DefaultYoutubeTranscriptApi.joinFutures(futures, playlistId);
        return transcriptLists;
    }

    @Override
    public Map<String, TranscriptContent> getTranscriptsForPlaylist(String playlistId, TranscriptRequest request, String ... languageCodes) throws TranscriptRetrievalException {
        Map<String, TranscriptList> transcriptLists = this.listTranscriptsForPlaylist(playlistId, request);
        ConcurrentHashMap<String, TranscriptContent> transcripts = new ConcurrentHashMap<String, TranscriptContent>();
        List<CompletableFuture<Void>> futures = transcriptLists.values().stream().map(transcriptList -> CompletableFuture.supplyAsync(() -> DefaultYoutubeTranscriptApi.transcriptContentSupplier(request, languageCodes, transcriptList)).thenAccept(transcriptContent -> {
            if (transcriptContent != null) {
                transcripts.put(transcriptList.getVideoId(), (TranscriptContent)transcriptContent);
            }
        })).collect(Collectors.toList());
        DefaultYoutubeTranscriptApi.joinFutures(futures, playlistId);
        return transcripts;
    }

    @Override
    public Map<String, TranscriptList> listTranscriptsForChannel(String channelName, TranscriptRequest request) throws TranscriptRetrievalException {
        String channelPlaylistId = this.youtubeApi.getChannelPlaylistId(channelName, request.getApiKey());
        return this.listTranscriptsForPlaylist(channelPlaylistId, request);
    }

    @Override
    public Map<String, TranscriptContent> getTranscriptsForChannel(String channelName, TranscriptRequest request, String ... languageCodes) throws TranscriptRetrievalException {
        String channelPlaylistId = this.youtubeApi.getChannelPlaylistId(channelName, request.getApiKey());
        return this.getTranscriptsForPlaylist(channelPlaylistId, request, languageCodes);
    }

    private void validateVideoId(String videoId) {
        if (!videoId.matches("[a-zA-Z0-9_-]{11}")) {
            throw new IllegalArgumentException("Invalid video id: " + videoId);
        }
    }

    private TranscriptList transcriptListSupplier(TranscriptRequest request, String videoId) {
        try {
            String cookiesPath = request.getCookiesPath();
            if (cookiesPath != null) {
                return this.listTranscriptsWithCookies(videoId, cookiesPath);
            }
            return this.listTranscripts(videoId);
        }
        catch (TranscriptRetrievalException e) {
            if (request.isStopOnError()) {
                throw new CompletionException(e);
            }
            return null;
        }
    }
}

