/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.CreateVectorStoreRequest;
import io.github.stefanbratanov.jvm.openai.DeletionStatus;
import io.github.stefanbratanov.jvm.openai.Endpoint;
import io.github.stefanbratanov.jvm.openai.ModifyVectorStoreRequest;
import io.github.stefanbratanov.jvm.openai.OpenAIAssistantsClient;
import io.github.stefanbratanov.jvm.openai.PaginationQueryParameters;
import io.github.stefanbratanov.jvm.openai.VectorStore;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public final class VectorStoresClient
extends OpenAIAssistantsClient {
    private final URI baseUrl;

    VectorStoresClient(URI baseUrl, String[] authenticationHeaders, HttpClient httpClient, Optional<Duration> requestTimeout) {
        super(authenticationHeaders, httpClient, requestTimeout);
        this.baseUrl = baseUrl;
    }

    public VectorStore createVectorStore(CreateVectorStoreRequest request) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.VECTOR_STORES.getPath())).POST(this.createBodyPublisher(request)).build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), VectorStore.class);
    }

    public PaginatedVectorStores listVectorStores(PaginationQueryParameters paginationQueryParameters) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.VECTOR_STORES.getPath() + this.createQueryParameters(paginationQueryParameters))).GET().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), PaginatedVectorStores.class);
    }

    public VectorStore retrieveVectorStore(String vectorStoreId) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.VECTOR_STORES.getPath() + "/" + vectorStoreId)).GET().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), VectorStore.class);
    }

    public VectorStore modifyVectorStore(String vectorStoreId, ModifyVectorStoreRequest request) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.VECTOR_STORES.getPath() + "/" + vectorStoreId)).POST(this.createBodyPublisher(request)).build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), VectorStore.class);
    }

    public DeletionStatus deleteVectorStore(String vectorStoreId) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.VECTOR_STORES.getPath() + "/" + vectorStoreId)).DELETE().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), DeletionStatus.class);
    }

    public record PaginatedVectorStores(List<VectorStore> data, String firstId, String lastId, boolean hasMore) {
    }
}

