/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.CreateVectorStoreFileBatchRequest;
import io.github.stefanbratanov.jvm.openai.Endpoint;
import io.github.stefanbratanov.jvm.openai.OpenAIAssistantsClient;
import io.github.stefanbratanov.jvm.openai.PaginationQueryParameters;
import io.github.stefanbratanov.jvm.openai.VectorStoreFile;
import io.github.stefanbratanov.jvm.openai.VectorStoreFileBatch;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class VectorStoreFileBatchesClient
extends OpenAIAssistantsClient {
    private static final String FILE_BATCHES_SEGMENT = "/file_batches";
    private final URI baseUrl;

    VectorStoreFileBatchesClient(URI baseUrl, String[] authenticationHeaders, HttpClient httpClient, Optional<Duration> requestTimeout) {
        super(authenticationHeaders, httpClient, requestTimeout);
        this.baseUrl = baseUrl;
    }

    public VectorStoreFileBatch createVectorStoreFileBatch(String vectorStoreId, CreateVectorStoreFileBatchRequest request) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.VECTOR_STORES.getPath() + "/" + vectorStoreId + FILE_BATCHES_SEGMENT)).POST(this.createBodyPublisher(request)).build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), VectorStoreFileBatch.class);
    }

    public VectorStoreFileBatch retrieveVectorStoreFileBatch(String vectorStoreId, String batchId) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.VECTOR_STORES.getPath() + "/" + vectorStoreId + "/file_batches/" + batchId)).GET().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), VectorStoreFileBatch.class);
    }

    public VectorStoreFileBatch cancelVectorStoreFileBatch(String vectorStoreId, String batchId) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.VECTOR_STORES.getPath() + "/" + vectorStoreId + "/file_batches/" + batchId + "/cancel")).POST(HttpRequest.BodyPublishers.noBody()).build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), VectorStoreFileBatch.class);
    }

    public PaginatedVectorStoreFiles listVectorStoreFilesInBatch(String vectorStoreId, String batchId, PaginationQueryParameters paginationQueryParameters, Optional<String> filter) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.VECTOR_STORES.getPath() + "/" + vectorStoreId + "/file_batches/" + batchId + "/files" + this.createQueryParameters(paginationQueryParameters, Map.of("filter", filter)))).GET().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), PaginatedVectorStoreFiles.class);
    }

    public record PaginatedVectorStoreFiles(List<VectorStoreFile> data, String firstId, String lastId, boolean hasMore) {
    }
}

