/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.ChunkingStrategy;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public record ToolResources(CodeInterpreter codeInterpreter, FileSearch fileSearch) {
    public static ToolResources codeInterpreterToolResources(List<String> fileIds) {
        return new ToolResources(new CodeInterpreter(fileIds), null);
    }

    public static ToolResources fileSearchToolResources(String ... vectorStoreIds) {
        return new ToolResources(null, new FileSearch(Optional.of(vectorStoreIds), Optional.empty()));
    }

    public static ToolResources fileSearchToolResources(FileSearch.VectorStore ... vectorStores) {
        return new ToolResources(null, new FileSearch(Optional.empty(), Optional.of(vectorStores)));
    }

    public static ToolResources codeInterpreterAndFileSearchToolResources(List<String> fileIds, String ... vectorStoreIds) {
        return new ToolResources(new CodeInterpreter(fileIds), new FileSearch(Optional.of(vectorStoreIds), Optional.empty()));
    }

    public static ToolResources codeInterpreterAndFileSearchToolResources(List<String> fileIds, FileSearch.VectorStore ... vectorStores) {
        return new ToolResources(new CodeInterpreter(fileIds), new FileSearch(Optional.empty(), Optional.of(vectorStores)));
    }

    public record CodeInterpreter(List<String> fileIds) {
    }

    public record FileSearch(Optional<String[]> vectorStoreIds, Optional<VectorStore[]> vectorStores) {

        public record VectorStore(Optional<List<String>> fileIds, Optional<ChunkingStrategy> chunkingStrategy, Optional<Map<String, String>> metadata) {
            public static Builder newBuilder() {
                return new Builder();
            }

            public static class Builder {
                private Optional<List<String>> fileIds = Optional.empty();
                private Optional<ChunkingStrategy> chunkingStrategy = Optional.empty();
                private Optional<Map<String, String>> metadata = Optional.empty();

                public Builder fileIds(List<String> fileIds) {
                    this.fileIds = Optional.of(fileIds);
                    return this;
                }

                public Builder chunkingStrategy(ChunkingStrategy chunkingStrategy) {
                    this.chunkingStrategy = Optional.of(chunkingStrategy);
                    return this;
                }

                public Builder metadata(Map<String, String> metadata) {
                    this.metadata = Optional.of(metadata);
                    return this;
                }

                public VectorStore build() {
                    return new VectorStore(this.fileIds, this.chunkingStrategy, this.metadata);
                }
            }
        }
    }
}

