/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.github.stefanbratanov.jvm.openai.Function;
import java.util.Optional;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", include=JsonTypeInfo.As.EXISTING_PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=CodeInterpreterTool.class, name="code_interpreter"), @JsonSubTypes.Type(value=FileSearchTool.class, name="file_search"), @JsonSubTypes.Type(value=FunctionTool.class, name="function")})
public interface Tool {
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String type();

    public static CodeInterpreterTool codeInterpreterTool() {
        return new CodeInterpreterTool();
    }

    public static FileSearchTool fileSearchTool() {
        return new FileSearchTool(Optional.empty());
    }

    public static FileSearchTool fileSearchTool(int maxNumResults) {
        return new FileSearchTool(Optional.of(new FileSearchTool.FileSearch(Optional.of(maxNumResults))));
    }

    public static FunctionTool functionTool(Function function) {
        return new FunctionTool(function);
    }

    public record CodeInterpreterTool() implements Tool
    {
        @Override
        public String type() {
            return "code_interpreter";
        }
    }

    public record FileSearchTool(Optional<FileSearch> fileSearch) implements Tool
    {
        @Override
        public String type() {
            return "file_search";
        }

        public record FileSearch(Optional<Integer> maxNumResults) {
        }
    }

    public record FunctionTool(Function function) implements Tool
    {
        @Override
        public String type() {
            return "function";
        }
    }
}

