/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public record SubmitToolOutputsRequest(List<ToolOutput> toolOutputs, Optional<Boolean> stream) {
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final List<ToolOutput> toolOutputs = new LinkedList<ToolOutput>();
        private Optional<Boolean> stream = Optional.empty();

        public Builder toolOutput(ToolOutput toolOutput) {
            this.toolOutputs.add(toolOutput);
            return this;
        }

        public Builder toolOutputs(List<ToolOutput> toolOutputs) {
            this.toolOutputs.addAll(toolOutputs);
            return this;
        }

        public Builder stream(boolean stream) {
            this.stream = Optional.of(stream);
            return this;
        }

        public SubmitToolOutputsRequest build() {
            return new SubmitToolOutputsRequest(List.copyOf(this.toolOutputs), this.stream);
        }
    }

    public record ToolOutput(Optional<String> toolCallId, Optional<String> output) {
        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private Optional<String> toolCallId = Optional.empty();
            private Optional<String> output = Optional.empty();

            public Builder toolCallId(String toolCallId) {
                this.toolCallId = Optional.of(toolCallId);
                return this;
            }

            public Builder output(String output) {
                this.output = Optional.of(output);
                return this;
            }

            public ToolOutput build() {
                return new ToolOutput(this.toolCallId, this.output);
            }
        }
    }
}

