/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.AssistantStreamEvent;
import io.github.stefanbratanov.jvm.openai.AssistantStreamEventSubscriber;
import io.github.stefanbratanov.jvm.openai.CreateRunRequest;
import io.github.stefanbratanov.jvm.openai.CreateThreadAndRunRequest;
import io.github.stefanbratanov.jvm.openai.Endpoint;
import io.github.stefanbratanov.jvm.openai.ModifyRunRequest;
import io.github.stefanbratanov.jvm.openai.OpenAIAssistantsClient;
import io.github.stefanbratanov.jvm.openai.PaginationQueryParameters;
import io.github.stefanbratanov.jvm.openai.SubmitToolOutputsRequest;
import io.github.stefanbratanov.jvm.openai.Thread;
import io.github.stefanbratanov.jvm.openai.ThreadMessage;
import io.github.stefanbratanov.jvm.openai.ThreadMessageDelta;
import io.github.stefanbratanov.jvm.openai.ThreadRun;
import io.github.stefanbratanov.jvm.openai.ThreadRunStep;
import io.github.stefanbratanov.jvm.openai.ThreadRunStepDelta;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class RunsClient
extends OpenAIAssistantsClient {
    private static final String RUNS_SEGMENT = "/runs";
    private final URI baseUrl;

    RunsClient(URI baseUrl, String[] authenticationHeaders, HttpClient httpClient, Optional<Duration> requestTimeout) {
        super(authenticationHeaders, httpClient, requestTimeout);
        this.baseUrl = baseUrl;
    }

    public ThreadRun createRun(String threadId, CreateRunRequest request) {
        HttpRequest httpRequest = this.createRunPostRequest(threadId, request);
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), ThreadRun.class);
    }

    public Stream<AssistantStreamEvent> createRunAndStream(String threadId, CreateRunRequest request) {
        this.validateStreamRequest(request::stream);
        HttpRequest httpRequest = this.createRunPostRequest(threadId, request);
        return this.getAssistantStreamEvents(httpRequest);
    }

    public void createRunAndStream(String threadId, CreateRunRequest request, AssistantStreamEventSubscriber subscriber) {
        this.validateStreamRequest(request::stream);
        HttpRequest httpRequest = this.createRunPostRequest(threadId, request);
        this.streamAndHandleAssistantEvents(httpRequest, subscriber);
    }

    public ThreadRun createThreadAndRun(CreateThreadAndRunRequest request) {
        HttpRequest httpRequest = this.createThreadAndRunPostRequest(request);
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), ThreadRun.class);
    }

    public Stream<AssistantStreamEvent> createThreadAndRunAndStream(CreateThreadAndRunRequest request) {
        this.validateStreamRequest(request::stream);
        HttpRequest httpRequest = this.createThreadAndRunPostRequest(request);
        return this.getAssistantStreamEvents(httpRequest);
    }

    public void createThreadAndRunAndStream(CreateThreadAndRunRequest request, AssistantStreamEventSubscriber subscriber) {
        this.validateStreamRequest(request::stream);
        HttpRequest httpRequest = this.createThreadAndRunPostRequest(request);
        this.streamAndHandleAssistantEvents(httpRequest, subscriber);
    }

    public PaginatedThreadRuns listRuns(String threadId, PaginationQueryParameters paginationQueryParameters) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.THREADS.getPath() + "/" + threadId + RUNS_SEGMENT + this.createQueryParameters(paginationQueryParameters))).GET().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), PaginatedThreadRuns.class);
    }

    public ThreadRun retrieveRun(String threadId, String runId) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.THREADS.getPath() + "/" + threadId + "/runs/" + runId)).GET().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), ThreadRun.class);
    }

    public ThreadRun modifyRun(String threadId, String runId, ModifyRunRequest request) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.THREADS.getPath() + "/" + threadId + "/runs/" + runId)).POST(this.createBodyPublisher(request)).build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), ThreadRun.class);
    }

    public ThreadRun submitToolOutputs(String threadId, String runId, SubmitToolOutputsRequest request) {
        HttpRequest httpRequest = this.createSubmitToolOutputsPostRequest(threadId, runId, request);
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), ThreadRun.class);
    }

    public Stream<AssistantStreamEvent> submitToolOutputsAndStream(String threadId, String runId, SubmitToolOutputsRequest request) {
        this.validateStreamRequest(request::stream);
        HttpRequest httpRequest = this.createSubmitToolOutputsPostRequest(threadId, runId, request);
        return this.getAssistantStreamEvents(httpRequest);
    }

    public void submitToolOutputsAndStream(String threadId, String runId, SubmitToolOutputsRequest request, AssistantStreamEventSubscriber subscriber) {
        this.validateStreamRequest(request::stream);
        HttpRequest httpRequest = this.createSubmitToolOutputsPostRequest(threadId, runId, request);
        this.streamAndHandleAssistantEvents(httpRequest, subscriber);
    }

    public ThreadRun cancelRun(String threadId, String runId) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.THREADS.getPath() + "/" + threadId + "/runs/" + runId + "/cancel")).POST(HttpRequest.BodyPublishers.noBody()).build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), ThreadRun.class);
    }

    private HttpRequest createRunPostRequest(String threadId, CreateRunRequest request) {
        return this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.THREADS.getPath() + "/" + threadId + RUNS_SEGMENT)).POST(this.createBodyPublisher(request)).build();
    }

    private HttpRequest createThreadAndRunPostRequest(CreateThreadAndRunRequest request) {
        return this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.THREADS.getPath() + RUNS_SEGMENT)).POST(this.createBodyPublisher(request)).build();
    }

    private HttpRequest createSubmitToolOutputsPostRequest(String threadId, String runId, SubmitToolOutputsRequest request) {
        return this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.THREADS.getPath() + "/" + threadId + "/runs/" + runId + "/submit_tool_outputs")).POST(this.createBodyPublisher(request)).build();
    }

    private Stream<AssistantStreamEvent> getAssistantStreamEvents(HttpRequest httpRequest) {
        return this.streamRawAssistantEvents(httpRequest).map(rawAssistantStreamEvent -> {
            String event = rawAssistantStreamEvent.event;
            String rawData = rawAssistantStreamEvent.data;
            AssistantStreamEvent.Data data = null;
            if (event.startsWith("thread.run.step.delta")) {
                data = this.deserializeData(rawData, ThreadRunStepDelta.class);
            } else if (event.startsWith("thread.run.step")) {
                data = this.deserializeData(rawData, ThreadRunStep.class);
            } else if (event.startsWith("thread.run")) {
                data = this.deserializeData(rawData, ThreadRun.class);
            } else if (event.startsWith("thread.message.delta")) {
                data = this.deserializeData(rawData, ThreadMessageDelta.class);
            } else if (event.startsWith("thread.message")) {
                data = this.deserializeData(rawData, ThreadMessage.class);
            } else if (event.startsWith("thread")) {
                data = this.deserializeData(rawData, Thread.class);
            }
            return new AssistantStreamEvent(event, data);
        });
    }

    private void streamAndHandleAssistantEvents(HttpRequest httpRequest, AssistantStreamEventSubscriber subscriber) {
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.streamRawAssistantEvents(httpRequest)).thenAccept(rawAssistantStreamEvents -> rawAssistantStreamEvents.forEach(rawAssistantStreamEvent -> this.handleRawAssistantStreamEvent((RawAssistantStreamEvent)rawAssistantStreamEvent, subscriber)))).whenComplete((result, ex) -> {
            if (ex != null) {
                subscriber.onException((Throwable)ex);
            }
            subscriber.onComplete();
        });
    }

    private Stream<RawAssistantStreamEvent> streamRawAssistantEvents(HttpRequest httpRequest) {
        Stream<String> sseEvents = this.streamServerSentEvents(httpRequest);
        return StreamSupport.stream(new RawAssistantStreamEventSpliterator(sseEvents), false);
    }

    private void handleRawAssistantStreamEvent(RawAssistantStreamEvent rawAssistantStreamEvent, AssistantStreamEventSubscriber subscriber) {
        String event = rawAssistantStreamEvent.event;
        String data = rawAssistantStreamEvent.data;
        if (event.startsWith("thread.run.step.delta")) {
            subscriber.onThreadRunStepDelta(event, this.deserializeData(data, ThreadRunStepDelta.class));
        } else if (event.startsWith("thread.run.step")) {
            subscriber.onThreadRunStep(event, this.deserializeData(data, ThreadRunStep.class));
        } else if (event.startsWith("thread.run")) {
            subscriber.onThreadRun(event, this.deserializeData(data, ThreadRun.class));
        } else if (event.startsWith("thread.message.delta")) {
            subscriber.onThreadMessageDelta(event, this.deserializeData(data, ThreadMessageDelta.class));
        } else if (event.startsWith("thread.message")) {
            subscriber.onThreadMessage(event, this.deserializeData(data, ThreadMessage.class));
        } else if (event.startsWith("thread")) {
            subscriber.onThread(event, this.deserializeData(data, Thread.class));
        } else {
            subscriber.onUnknownEvent(event, data);
        }
    }

    public record PaginatedThreadRuns(List<ThreadRun> data, String firstId, String lastId, boolean hasMore) {
    }

    private static class RawAssistantStreamEventSpliterator
    implements Spliterator<RawAssistantStreamEvent> {
        private final Iterator<String> sseEventsIterator;

        RawAssistantStreamEventSpliterator(Stream<String> sseEvents) {
            this.sseEventsIterator = sseEvents.iterator();
        }

        @Override
        public boolean tryAdvance(Consumer<? super RawAssistantStreamEvent> action) {
            String event = this.getNextValue();
            if (event == null) {
                return false;
            }
            String data = this.getNextValue();
            if (data == null) {
                return false;
            }
            action.accept(new RawAssistantStreamEvent(event, data));
            return true;
        }

        @Override
        public Spliterator<RawAssistantStreamEvent> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 272;
        }

        private String getNextValue() {
            if (!this.sseEventsIterator.hasNext()) {
                return null;
            }
            return this.sseEventsIterator.next().split(":", 2)[1].trim();
        }
    }

    private record RawAssistantStreamEvent(String event, String data) {
    }
}

