/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import java.util.Optional;

public record PaginationQueryParameters(Optional<Integer> limit, Optional<String> order, Optional<String> before, Optional<String> after) {
    public static PaginationQueryParameters none() {
        return new Builder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Optional<Integer> limit = Optional.empty();
        private Optional<String> order = Optional.empty();
        private Optional<String> before = Optional.empty();
        private Optional<String> after = Optional.empty();

        public Builder limit(int limit) {
            this.limit = Optional.of(limit);
            return this;
        }

        public Builder order(String order) {
            this.order = Optional.of(order);
            return this;
        }

        public Builder before(String before) {
            this.before = Optional.of(before);
            return this;
        }

        public Builder after(String after) {
            this.after = Optional.of(after);
            return this;
        }

        public PaginationQueryParameters build() {
            return new PaginationQueryParameters(this.limit, this.order, this.before, this.after);
        }
    }
}

