/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.stefanbratanov.jvm.openai.ObjectMapperSingleton;
import io.github.stefanbratanov.jvm.openai.OpenAIException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class OpenAIClient {
    private static final String STREAM_TERMINATION_REGEX = "(data: \\[DONE]|event: done)";
    private final ObjectMapper objectMapper = ObjectMapperSingleton.getInstance();
    private final String[] authenticationHeaders;
    private final HttpClient httpClient;
    private final Optional<Duration> requestTimeout;

    OpenAIClient(String[] authenticationHeaders, HttpClient httpClient, Optional<Duration> requestTimeout) {
        this.authenticationHeaders = authenticationHeaders;
        this.httpClient = httpClient;
        this.requestTimeout = requestTimeout;
    }

    HttpRequest.Builder newHttpRequestBuilder(String ... headers) {
        HttpRequest.Builder httpRequestBuilder = HttpRequest.newBuilder().headers(this.authenticationHeaders);
        if (headers.length > 0) {
            httpRequestBuilder.headers(headers);
        }
        this.requestTimeout.ifPresent(httpRequestBuilder::timeout);
        return httpRequestBuilder;
    }

    String createQueryParameters(Map<String, Optional<?>> queryParameters) {
        return queryParameters.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).map(entry -> (String)entry.getKey() + "=" + ((Optional)entry.getValue()).get()).collect(Collectors.joining("&", "?", ""));
    }

    <T> HttpRequest.BodyPublisher createBodyPublisher(T body) {
        try {
            return HttpRequest.BodyPublishers.ofByteArray(this.objectMapper.writeValueAsBytes(body));
        }
        catch (JsonProcessingException ex) {
            throw new UncheckedIOException((IOException)((Object)ex));
        }
    }

    HttpResponse<byte[]> sendHttpRequest(HttpRequest httpRequest) {
        return this.sendHttpRequest(httpRequest, HttpResponse.BodyHandlers.ofByteArray());
    }

    <T> HttpResponse<T> sendHttpRequest(HttpRequest httpRequest, HttpResponse.BodyHandler<T> responseBodyHandler) {
        try {
            HttpResponse<T> httpResponse = this.httpClient.send(httpRequest, responseBodyHandler);
            this.validateHttpResponse(httpResponse);
            return httpResponse;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Operation was interrupted", ex);
        }
    }

    CompletableFuture<HttpResponse<byte[]>> sendHttpRequestAsync(HttpRequest httpRequest) {
        return this.sendHttpRequestAsync(httpRequest, HttpResponse.BodyHandlers.ofByteArray());
    }

    <T> CompletableFuture<HttpResponse<T>> sendHttpRequestAsync(HttpRequest httpRequest, HttpResponse.BodyHandler<T> responseBodyHandler) {
        return this.httpClient.sendAsync(httpRequest, responseBodyHandler).thenApply(httpResponse -> {
            this.validateHttpResponse((HttpResponse<?>)httpResponse);
            return httpResponse;
        });
    }

    Stream<String> streamServerSentEvents(HttpRequest httpRequest) {
        return this.sendHttpRequest(httpRequest, HttpResponse.BodyHandlers.ofLines()).body().filter(sseEvent -> !sseEvent.isBlank()).takeWhile(sseEvent -> !sseEvent.matches(STREAM_TERMINATION_REGEX));
    }

    void validateStreamRequest(Supplier<Optional<Boolean>> streamField) {
        if (!streamField.get().orElse(false).booleanValue()) {
            throw new IllegalArgumentException("stream must be set to true when requesting a stream");
        }
    }

    void validateHttpResponse(HttpResponse<?> httpResponse) {
        int statusCode = httpResponse.statusCode();
        if (statusCode < 200 || statusCode > 299) {
            this.getErrorFromHttpResponse(httpResponse).ifPresentOrElse(error -> {
                throw new OpenAIException(statusCode, (OpenAIException.Error)error);
            }, () -> {
                throw new OpenAIException(statusCode, null);
            });
        }
    }

    <T> T deserializeResponse(byte[] response, Class<T> responseClass) {
        try {
            return (T)this.objectMapper.readValue(response, responseClass);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    <T> T deserializeData(String data, Class<T> responseClass) {
        try {
            return (T)this.objectMapper.readValue(data, responseClass);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    <T> List<T> deserializeDataInResponseAsList(byte[] response, Class<T> elementType) {
        try {
            JsonNode responseNode = this.objectMapper.readTree(response);
            return (List)this.objectMapper.readValue(responseNode.get("data").traverse(), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, elementType));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private Optional<OpenAIException.Error> getErrorFromHttpResponse(HttpResponse<?> httpResponse) {
        return this.getErrorBodyFromHttpResponse(httpResponse).flatMap(body -> {
            try {
                JsonNode errorNode = this.objectMapper.readTree(body).get("error");
                if (errorNode == null) {
                    return Optional.empty();
                }
                return Optional.of((OpenAIException.Error)this.objectMapper.treeToValue((TreeNode)errorNode, OpenAIException.Error.class));
            }
            catch (JsonProcessingException ex) {
                return Optional.empty();
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        });
    }

    private Optional<byte[]> getErrorBodyFromHttpResponse(HttpResponse<?> httpResponse) {
        byte[] body;
        if (httpResponse.body() instanceof byte[]) {
            body = (byte[])httpResponse.body();
        } else {
            Object obj = httpResponse.body();
            if (obj instanceof Path) {
                Path path = (Path)obj;
                try {
                    body = Files.readAllBytes(path);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            } else {
                obj = httpResponse.body();
                if (obj instanceof Stream) {
                    Stream stream = (Stream)obj;
                    body = stream.map(String.class::cast).collect(Collectors.joining()).getBytes();
                } else {
                    return Optional.empty();
                }
            }
        }
        return Optional.of(body);
    }
}

