/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.AssistantsClient;
import io.github.stefanbratanov.jvm.openai.AudioClient;
import io.github.stefanbratanov.jvm.openai.BatchClient;
import io.github.stefanbratanov.jvm.openai.ChatClient;
import io.github.stefanbratanov.jvm.openai.EmbeddingsClient;
import io.github.stefanbratanov.jvm.openai.FilesClient;
import io.github.stefanbratanov.jvm.openai.FineTuningClient;
import io.github.stefanbratanov.jvm.openai.ImagesClient;
import io.github.stefanbratanov.jvm.openai.MessagesClient;
import io.github.stefanbratanov.jvm.openai.ModelsClient;
import io.github.stefanbratanov.jvm.openai.ModerationsClient;
import io.github.stefanbratanov.jvm.openai.RunStepsClient;
import io.github.stefanbratanov.jvm.openai.RunsClient;
import io.github.stefanbratanov.jvm.openai.ThreadsClient;
import io.github.stefanbratanov.jvm.openai.UploadsClient;
import io.github.stefanbratanov.jvm.openai.VectorStoreFileBatchesClient;
import io.github.stefanbratanov.jvm.openai.VectorStoreFilesClient;
import io.github.stefanbratanov.jvm.openai.VectorStoresClient;
import java.net.URI;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Optional;

public final class OpenAI {
    private final AudioClient audioClient;
    private final ChatClient chatClient;
    private final EmbeddingsClient embeddingsClient;
    private final FineTuningClient fineTuningClient;
    private final BatchClient batchClient;
    private final FilesClient filesClient;
    private final UploadsClient uploadsClient;
    private final ImagesClient imagesClient;
    private final ModelsClient modelsClient;
    private final ModerationsClient moderationsClient;
    private final AssistantsClient assistantsClient;
    private final ThreadsClient threadsClient;
    private final MessagesClient messagesClient;
    private final RunsClient runsClient;
    private final RunStepsClient runStepsClient;
    private final VectorStoresClient vectorStoresClient;
    private final VectorStoreFilesClient vectorStoreFilesClient;
    private final VectorStoreFileBatchesClient vectorStoreFileBatchesClient;

    private OpenAI(URI baseUrl, String apiKey, Optional<String> organization, Optional<String> project, HttpClient httpClient, Optional<Duration> requestTimeout) {
        String[] authenticationHeaders = this.createAuthenticationHeaders(apiKey, organization, project);
        this.audioClient = new AudioClient(baseUrl, authenticationHeaders, httpClient, requestTimeout);
        this.chatClient = new ChatClient(baseUrl, authenticationHeaders, httpClient, requestTimeout);
        this.embeddingsClient = new EmbeddingsClient(baseUrl, authenticationHeaders, httpClient, requestTimeout);
        this.fineTuningClient = new FineTuningClient(baseUrl, authenticationHeaders, httpClient, requestTimeout);
        this.batchClient = new BatchClient(baseUrl, authenticationHeaders, httpClient, requestTimeout);
        this.filesClient = new FilesClient(baseUrl, authenticationHeaders, httpClient, requestTimeout);
        this.uploadsClient = new UploadsClient(baseUrl, authenticationHeaders, httpClient, requestTimeout);
        this.imagesClient = new ImagesClient(baseUrl, authenticationHeaders, httpClient, requestTimeout);
        this.modelsClient = new ModelsClient(baseUrl, authenticationHeaders, httpClient, requestTimeout);
        this.moderationsClient = new ModerationsClient(baseUrl, authenticationHeaders, httpClient, requestTimeout);
        this.assistantsClient = new AssistantsClient(baseUrl, authenticationHeaders, httpClient, requestTimeout);
        this.threadsClient = new ThreadsClient(baseUrl, authenticationHeaders, httpClient, requestTimeout);
        this.messagesClient = new MessagesClient(baseUrl, authenticationHeaders, httpClient, requestTimeout);
        this.runsClient = new RunsClient(baseUrl, authenticationHeaders, httpClient, requestTimeout);
        this.runStepsClient = new RunStepsClient(baseUrl, authenticationHeaders, httpClient, requestTimeout);
        this.vectorStoresClient = new VectorStoresClient(baseUrl, authenticationHeaders, httpClient, requestTimeout);
        this.vectorStoreFilesClient = new VectorStoreFilesClient(baseUrl, authenticationHeaders, httpClient, requestTimeout);
        this.vectorStoreFileBatchesClient = new VectorStoreFileBatchesClient(baseUrl, authenticationHeaders, httpClient, requestTimeout);
    }

    public AudioClient audioClient() {
        return this.audioClient;
    }

    public ChatClient chatClient() {
        return this.chatClient;
    }

    public EmbeddingsClient embeddingsClient() {
        return this.embeddingsClient;
    }

    public FineTuningClient fineTuningClient() {
        return this.fineTuningClient;
    }

    public BatchClient batchClient() {
        return this.batchClient;
    }

    public FilesClient filesClient() {
        return this.filesClient;
    }

    public UploadsClient uploadsClient() {
        return this.uploadsClient;
    }

    public ImagesClient imagesClient() {
        return this.imagesClient;
    }

    public ModelsClient modelsClient() {
        return this.modelsClient;
    }

    public ModerationsClient moderationsClient() {
        return this.moderationsClient;
    }

    public AssistantsClient assistantsClient() {
        return this.assistantsClient;
    }

    public ThreadsClient threadsClient() {
        return this.threadsClient;
    }

    public MessagesClient messagesClient() {
        return this.messagesClient;
    }

    public RunsClient runsClient() {
        return this.runsClient;
    }

    public RunStepsClient runStepsClient() {
        return this.runStepsClient;
    }

    public VectorStoresClient vectorStoresClient() {
        return this.vectorStoresClient;
    }

    public VectorStoreFilesClient vectorStoreFilesClient() {
        return this.vectorStoreFilesClient;
    }

    public VectorStoreFileBatchesClient vectorStoreFileBatchesClient() {
        return this.vectorStoreFileBatchesClient;
    }

    private String[] createAuthenticationHeaders(String apiKey, Optional<String> organization, Optional<String> project) {
        ArrayList<Object> authHeaders = new ArrayList<Object>();
        authHeaders.add("Authorization");
        authHeaders.add("Bearer " + apiKey);
        organization.ifPresent(org -> {
            authHeaders.add("OpenAI-Organization");
            authHeaders.add(org);
        });
        project.ifPresent(prj -> {
            authHeaders.add("OpenAI-Project");
            authHeaders.add(prj);
        });
        return authHeaders.toArray(new String[0]);
    }

    public static Builder newBuilder(String apiKey) {
        return new Builder(apiKey);
    }

    public static class Builder {
        private static final String DEFAULT_BASE_URL = "https://api.openai.com/v1/";
        private final String apiKey;
        private String baseUrl = "https://api.openai.com/v1/";
        private Optional<String> organization = Optional.empty();
        private Optional<String> project = Optional.empty();
        private Optional<HttpClient> httpClient = Optional.empty();
        private Optional<Duration> requestTimeout = Optional.empty();

        public Builder(String apiKey) {
            this.apiKey = apiKey;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder organization(String organization) {
            this.organization = Optional.of(organization);
            return this;
        }

        public Builder project(String project) {
            this.project = Optional.of(project);
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = Optional.of(httpClient);
            return this;
        }

        public Builder requestTimeout(Duration requestTimeout) {
            this.requestTimeout = Optional.of(requestTimeout);
            return this;
        }

        public OpenAI build() {
            if (!this.baseUrl.endsWith("/")) {
                this.baseUrl = this.baseUrl + "/";
            }
            return new OpenAI(URI.create(this.baseUrl), this.apiKey, this.organization, this.project, this.httpClient.orElseGet(HttpClient::newHttpClient), this.requestTimeout);
        }
    }
}

