/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.OpenAIModel;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public record ModerationRequest(List<String> input, Optional<String> model) {
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final List<String> input = new LinkedList<String>();
        private Optional<String> model = Optional.empty();

        public Builder input(String input) {
            this.input.add(input);
            return this;
        }

        public Builder inputs(List<String> inputs) {
            this.input.addAll(inputs);
            return this;
        }

        public Builder model(String model) {
            this.model = Optional.of(model);
            return this;
        }

        public Builder model(OpenAIModel model) {
            this.model = Optional.of(model.getId());
            return this;
        }

        public ModerationRequest build() {
            return new ModerationRequest(List.copyOf(this.input), this.model);
        }
    }
}

