/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.CreateMessageRequest;
import io.github.stefanbratanov.jvm.openai.DeletionStatus;
import io.github.stefanbratanov.jvm.openai.Endpoint;
import io.github.stefanbratanov.jvm.openai.ModifyMessageRequest;
import io.github.stefanbratanov.jvm.openai.OpenAIAssistantsClient;
import io.github.stefanbratanov.jvm.openai.PaginationQueryParameters;
import io.github.stefanbratanov.jvm.openai.ThreadMessage;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class MessagesClient
extends OpenAIAssistantsClient {
    private static final String MESSAGES_SEGMENT = "/messages";
    private final URI baseUrl;

    MessagesClient(URI baseUrl, String[] authenticationHeaders, HttpClient httpClient, Optional<Duration> requestTimeout) {
        super(authenticationHeaders, httpClient, requestTimeout);
        this.baseUrl = baseUrl;
    }

    public ThreadMessage createMessage(String threadId, CreateMessageRequest request) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.THREADS.getPath() + "/" + threadId + MESSAGES_SEGMENT)).POST(this.createBodyPublisher(request)).build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), ThreadMessage.class);
    }

    public PaginatedThreadMessages listMessages(String threadId, PaginationQueryParameters paginationQueryParameters, Optional<String> runId) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.THREADS.getPath() + "/" + threadId + MESSAGES_SEGMENT + this.createQueryParameters(paginationQueryParameters, Map.of("run_id", runId)))).GET().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), PaginatedThreadMessages.class);
    }

    public ThreadMessage retrieveMessage(String threadId, String messageId) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.THREADS.getPath() + "/" + threadId + "/messages/" + messageId)).GET().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), ThreadMessage.class);
    }

    public ThreadMessage modifyMessage(String threadId, String messageId, ModifyMessageRequest request) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.THREADS.getPath() + "/" + threadId + "/messages/" + messageId)).POST(this.createBodyPublisher(request)).build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), ThreadMessage.class);
    }

    public DeletionStatus deleteMessage(String threadId, String messageId) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.THREADS.getPath() + "/" + threadId + "/messages/" + messageId)).DELETE().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), DeletionStatus.class);
    }

    public record PaginatedThreadMessages(List<ThreadMessage> data, String firstId, String lastId, boolean hasMore) {
    }
}

