/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.stefanbratanov.jvm.openai.ObjectMapperSingleton;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public record Function(String name, Optional<String> description, Optional<Map<String, Object>> parameters) {
    public Function(String name, Optional<String> description, Optional<Map<String, Object>> parameters) {
        parameters = parameters.map(this::parametersWithoutJsonEscaping);
        this.name = name;
        this.description = description;
        this.parameters = parameters;
    }

    private Map<String, Object> parametersWithoutJsonEscaping(Map<String, Object> parameters) {
        return parameters.entrySet().stream().map(entry -> {
            Object patt718$temp = entry.getValue();
            if (patt718$temp instanceof String) {
                String value = (String)patt718$temp;
                try {
                    JsonNode node = ObjectMapperSingleton.getInstance().readTree(value);
                    if (node != null && !node.isNull()) {
                        return new AbstractMap.SimpleEntry<String, JsonNode>((String)entry.getKey(), node);
                    }
                }
                catch (IOException ex) {
                    return entry;
                }
            }
            return entry;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private Optional<String> description = Optional.empty();
        private Optional<Map<String, Object>> parameters = Optional.empty();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        public Builder parameters(Map<String, Object> parameters) {
            this.parameters = Optional.of(parameters);
            return this;
        }

        public Function build() {
            return new Function(this.name, this.description, this.parameters);
        }
    }
}

