/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.github.stefanbratanov.jvm.openai.CreateFineTuningJobRequest;
import io.github.stefanbratanov.jvm.openai.Endpoint;
import io.github.stefanbratanov.jvm.openai.FineTuningJob;
import io.github.stefanbratanov.jvm.openai.FineTuningJobCheckpoint;
import io.github.stefanbratanov.jvm.openai.FineTuningJobEvent;
import io.github.stefanbratanov.jvm.openai.OpenAIClient;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class FineTuningClient
extends OpenAIClient {
    private final URI baseUrl;

    FineTuningClient(URI baseUrl, String[] authenticationHeaders, HttpClient httpClient, Optional<Duration> requestTimeout) {
        super(authenticationHeaders, httpClient, requestTimeout);
        this.baseUrl = baseUrl;
    }

    public FineTuningJob createFineTuningJob(CreateFineTuningJobRequest request) {
        HttpRequest httpRequest = this.newHttpRequestBuilder("Content-Type", "application/json").uri(this.baseUrl.resolve(Endpoint.FINE_TUNING.getPath())).POST(this.createBodyPublisher(request)).build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), FineTuningJob.class);
    }

    public PaginatedFineTuningJobs listFineTuningJobs(Optional<Integer> limit, Optional<String> after) {
        String queryParameters = this.createQueryParameters(Map.of("limit", limit, "after", after));
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.FINE_TUNING.getPath() + queryParameters)).GET().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), PaginatedFineTuningJobs.class);
    }

    public PaginatedFineTuningEvents listFineTuningJobEvents(String fineTuningJobId, Optional<Integer> limit, Optional<String> after) {
        String queryParameters = this.createQueryParameters(Map.of("limit", limit, "after", after));
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.FINE_TUNING.getPath() + "/" + fineTuningJobId + "/events" + queryParameters)).GET().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), PaginatedFineTuningEvents.class);
    }

    public PaginatedFineTuningCheckpoints listFineTuningCheckpoints(String fineTuningJobId, Optional<Integer> limit, Optional<String> after) {
        String queryParameters = this.createQueryParameters(Map.of("limit", limit, "after", after));
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.FINE_TUNING.getPath() + "/" + fineTuningJobId + "/checkpoints" + queryParameters)).GET().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), PaginatedFineTuningCheckpoints.class);
    }

    public FineTuningJob retrieveFineTuningJob(String fineTuningJobId) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.FINE_TUNING.getPath() + "/" + fineTuningJobId)).GET().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), FineTuningJob.class);
    }

    public FineTuningJob cancelFineTuningJob(String fineTuningJobId) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.FINE_TUNING.getPath() + "/" + fineTuningJobId + "/cancel")).POST(HttpRequest.BodyPublishers.noBody()).build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), FineTuningJob.class);
    }

    public record PaginatedFineTuningJobs(List<FineTuningJob> data, boolean hasMore) {
        @JsonIgnore
        public String getLastJobId() {
            return this.data.get(this.data.size() - 1).id();
        }
    }

    public record PaginatedFineTuningEvents(List<FineTuningJobEvent> data, boolean hasMore) {
        @JsonIgnore
        public String getLastEventId() {
            return this.data.get(this.data.size() - 1).id();
        }
    }

    public record PaginatedFineTuningCheckpoints(List<FineTuningJobCheckpoint> data, String firstId, String lastId, boolean hasMore) {
    }
}

