/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.OpenAIModel;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public record EmbeddingsRequest(List<Object> input, String model, Optional<String> encodingFormat, Optional<Integer> dimensions, Optional<String> user) {
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private List<Object> input;
        private String model;
        private Optional<String> encodingFormat = Optional.empty();
        private Optional<Integer> dimensions = Optional.empty();
        private Optional<String> user = Optional.empty();

        public Builder input(String ... input) {
            this.input = Arrays.asList(input);
            return this;
        }

        public Builder input(int[] input) {
            this.input = List.of(input);
            return this;
        }

        public Builder input(List<int[]> input) {
            this.input = List.copyOf(input);
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder model(OpenAIModel model) {
            this.model = model.getId();
            return this;
        }

        public Builder encodingFormat(String encodingFormat) {
            this.encodingFormat = Optional.of(encodingFormat);
            return this;
        }

        public Builder dimensions(int dimensions) {
            this.dimensions = Optional.of(dimensions);
            return this;
        }

        public Builder user(String user) {
            this.user = Optional.of(user);
            return this;
        }

        public EmbeddingsRequest build() {
            return new EmbeddingsRequest(this.input, this.model, this.encodingFormat, this.dimensions, this.user);
        }
    }
}

