/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.OpenAIModel;
import java.nio.file.Path;
import java.util.Optional;

public record EditImageRequest(Path image, String prompt, Optional<Path> mask, Optional<String> model, Optional<Integer> n, Optional<String> size, Optional<String> responseFormat, Optional<String> user) {
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Path image;
        private String prompt;
        private Optional<Path> mask = Optional.empty();
        private Optional<String> model = Optional.empty();
        private Optional<Integer> n = Optional.empty();
        private Optional<String> size = Optional.empty();
        private Optional<String> responseFormat = Optional.empty();
        private Optional<String> user = Optional.empty();

        public Builder image(Path image) {
            this.image = image;
            return this;
        }

        public Builder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public Builder mask(Path mask) {
            this.mask = Optional.of(mask);
            return this;
        }

        public Builder model(String model) {
            this.model = Optional.of(model);
            return this;
        }

        public Builder model(OpenAIModel model) {
            this.model = Optional.of(model.getId());
            return this;
        }

        public Builder n(int n) {
            this.n = Optional.of(n);
            return this;
        }

        public Builder size(String size) {
            this.size = Optional.of(size);
            return this;
        }

        public Builder responseFormat(String responseFormat) {
            this.responseFormat = Optional.of(responseFormat);
            return this;
        }

        public Builder user(String user) {
            this.user = Optional.of(user);
            return this;
        }

        public EditImageRequest build() {
            return new EditImageRequest(this.image, this.prompt, this.mask, this.model, this.n, this.size, this.responseFormat, this.user);
        }
    }
}

