/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", include=JsonTypeInfo.As.EXISTING_PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=CodeInterpreterToolCall.class, name="code_interpreter"), @JsonSubTypes.Type(value=FileSearchToolCall.class, name="file_search"), @JsonSubTypes.Type(value=FunctionToolCall.class, name="function")})
public interface DeltaToolCall {
    public int index();

    public String id();

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String type();

    public static CodeInterpreterToolCall codeInterpreterToolCall(int index, String id, CodeInterpreterToolCall.CodeInterpreter codeInterpreter) {
        return new CodeInterpreterToolCall(index, id, codeInterpreter);
    }

    public static FileSearchToolCall fileSearchToolCall(int index, String id) {
        return new FileSearchToolCall(index, id, Collections.emptyMap());
    }

    public static FunctionToolCall functionToolCall(int index, String id, FunctionToolCall.Function function) {
        return new FunctionToolCall(index, id, function);
    }

    public record CodeInterpreterToolCall(int index, String id, CodeInterpreter codeInterpreter) implements DeltaToolCall
    {
        @Override
        public String type() {
            return "code_interpreter";
        }

        public record CodeInterpreter(String input, List<Output> outputs) {

            /*
             * Uses 'sealed' constructs - enablewith --sealed true
             */
            @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", include=JsonTypeInfo.As.EXISTING_PROPERTY)
            @JsonSubTypes(value={@JsonSubTypes.Type(value=LogOutput.class, name="logs"), @JsonSubTypes.Type(value=ImageOutput.class, name="image")})
            public static interface Output {
                public int index();

                @JsonProperty(access=JsonProperty.Access.READ_ONLY)
                public String type();

                public static LogOutput logOutput(int index, String logs) {
                    return new LogOutput(index, logs);
                }

                public static ImageOutput imageOutput(int index, ImageOutput.Image image) {
                    return new ImageOutput(index, image);
                }

                public record LogOutput(int index, String logs) implements Output
                {
                    @Override
                    public String type() {
                        return "logs";
                    }
                }

                public record ImageOutput(int index, Image image) implements Output
                {
                    @Override
                    public String type() {
                        return "image";
                    }

                    public record Image(String fileId) {
                    }
                }
            }
        }
    }

    public record FileSearchToolCall(int index, String id, Map<String, Object> fileSearch) implements DeltaToolCall
    {
        @Override
        public String type() {
            return "file_search";
        }
    }

    public record FunctionToolCall(int index, String id, Function function) implements DeltaToolCall
    {
        @Override
        public String type() {
            return "function";
        }

        public record Function(int index, String name, String arguments, String output) {
        }
    }
}

