/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.ChunkingStrategy;
import io.github.stefanbratanov.jvm.openai.ExpiresAfter;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public record CreateVectorStoreRequest(Optional<List<String>> fileIds, Optional<String> name, Optional<ExpiresAfter> expiresAfter, Optional<ChunkingStrategy> chunkingStrategy, Optional<Map<String, String>> metadata) {
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Optional<List<String>> fileIds = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<ExpiresAfter> expiresAfter = Optional.empty();
        private Optional<ChunkingStrategy> chunkingStrategy = Optional.empty();
        private Optional<Map<String, String>> metadata = Optional.empty();

        public Builder fileIds(List<String> fileIds) {
            this.fileIds = Optional.of(fileIds);
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        public Builder expiresAfter(ExpiresAfter expiresAfter) {
            this.expiresAfter = Optional.of(expiresAfter);
            return this;
        }

        public Builder chunkingStrategy(ChunkingStrategy chunkingStrategy) {
            this.chunkingStrategy = Optional.of(chunkingStrategy);
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = Optional.of(metadata);
            return this;
        }

        public CreateVectorStoreRequest build() {
            return new CreateVectorStoreRequest(this.fileIds, this.name, this.expiresAfter, this.chunkingStrategy, this.metadata);
        }
    }
}

