/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.AssistantsResponseFormat;
import io.github.stefanbratanov.jvm.openai.AssistantsToolChoice;
import io.github.stefanbratanov.jvm.openai.CreateMessageRequest;
import io.github.stefanbratanov.jvm.openai.OpenAIModel;
import io.github.stefanbratanov.jvm.openai.Tool;
import io.github.stefanbratanov.jvm.openai.TruncationStrategy;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public record CreateRunRequest(String assistantId, Optional<String> model, Optional<String> instructions, Optional<String> additionalInstructions, Optional<List<CreateMessageRequest>> additionalMessages, Optional<List<Tool>> tools, Optional<Map<String, String>> metadata, Optional<Double> temperature, Optional<Double> topP, Optional<Boolean> stream, Optional<Integer> maxPromptTokens, Optional<Integer> maxCompletionTokens, Optional<TruncationStrategy> truncationStrategy, Optional<AssistantsToolChoice> toolChoice, Optional<Boolean> parallelToolCalls, Optional<AssistantsResponseFormat> responseFormat) {
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String assistantId;
        private Optional<String> model = Optional.empty();
        private Optional<String> instructions = Optional.empty();
        private Optional<String> additionalInstructions = Optional.empty();
        private Optional<List<CreateMessageRequest>> additionalMessages = Optional.empty();
        private Optional<List<Tool>> tools = Optional.empty();
        private Optional<Map<String, String>> metadata = Optional.empty();
        private Optional<Double> temperature = Optional.empty();
        private Optional<Double> topP = Optional.empty();
        private Optional<Boolean> stream = Optional.empty();
        private Optional<Integer> maxPromptTokens = Optional.empty();
        private Optional<Integer> maxCompletionTokens = Optional.empty();
        private Optional<TruncationStrategy> truncationStrategy = Optional.empty();
        private Optional<AssistantsToolChoice> toolChoice = Optional.empty();
        private Optional<Boolean> parallelToolCalls = Optional.empty();
        private Optional<AssistantsResponseFormat> responseFormat = Optional.empty();

        public Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public Builder model(String model) {
            this.model = Optional.of(model);
            return this;
        }

        public Builder model(OpenAIModel model) {
            this.model = Optional.of(model.getId());
            return this;
        }

        public Builder instructions(String instructions) {
            this.instructions = Optional.of(instructions);
            return this;
        }

        public Builder additionalInstructions(String additionalInstructions) {
            this.additionalInstructions = Optional.of(additionalInstructions);
            return this;
        }

        public Builder additionalMessages(List<CreateMessageRequest> additionalMessages) {
            this.additionalMessages = Optional.of(additionalMessages);
            return this;
        }

        public Builder tools(List<Tool> tools) {
            this.tools = Optional.of(tools);
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = Optional.of(metadata);
            return this;
        }

        public Builder temperature(double temperature) {
            this.temperature = Optional.of(temperature);
            return this;
        }

        public Builder topP(double topP) {
            this.topP = Optional.of(topP);
            return this;
        }

        public Builder stream(boolean stream) {
            this.stream = Optional.of(stream);
            return this;
        }

        public Builder maxPromptTokens(int maxPromptTokens) {
            this.maxPromptTokens = Optional.of(maxPromptTokens);
            return this;
        }

        public Builder maxCompletionTokens(int maxCompletionTokens) {
            this.maxCompletionTokens = Optional.of(maxCompletionTokens);
            return this;
        }

        public Builder truncationStrategy(TruncationStrategy truncationStrategy) {
            this.truncationStrategy = Optional.of(truncationStrategy);
            return this;
        }

        public Builder toolChoice(AssistantsToolChoice toolChoice) {
            this.toolChoice = Optional.of(toolChoice);
            return this;
        }

        public Builder parallelToolCalls(boolean parallelToolCalls) {
            this.parallelToolCalls = Optional.of(parallelToolCalls);
            return this;
        }

        public Builder responseFormat(AssistantsResponseFormat responseFormat) {
            this.responseFormat = Optional.of(responseFormat);
            return this;
        }

        public CreateRunRequest build() {
            return new CreateRunRequest(this.assistantId, this.model, this.instructions, this.additionalInstructions, this.additionalMessages, this.tools, this.metadata, this.temperature, this.topP, this.stream, this.maxPromptTokens, this.maxCompletionTokens, this.truncationStrategy, this.toolChoice, this.parallelToolCalls, this.responseFormat);
        }
    }
}

