/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.Attachment;
import io.github.stefanbratanov.jvm.openai.ContentPart;
import io.github.stefanbratanov.jvm.openai.Role;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public record CreateMessageRequest(String role, Object content, Optional<List<Attachment>> attachments, Optional<Map<String, String>> metadata) {
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String role = Role.USER.getId();
        private Object content;
        private Optional<List<Attachment>> attachments = Optional.empty();
        private Optional<Map<String, String>> metadata = Optional.empty();

        public Builder role(String role) {
            this.role = role;
            return this;
        }

        public Builder role(Role role) {
            this.role = role.getId();
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder content(List<ContentPart> content) {
            this.content = content;
            return this;
        }

        public Builder attachments(List<Attachment> attachments) {
            this.attachments = Optional.of(attachments);
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = Optional.of(metadata);
            return this;
        }

        public CreateMessageRequest build() {
            return new CreateMessageRequest(this.role, this.content, this.attachments, this.metadata);
        }
    }
}

