/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.OpenAIModel;
import java.nio.file.Path;
import java.util.Optional;

public record CreateImageVariationRequest(Path image, Optional<String> model, Optional<Integer> n, Optional<String> responseFormat, Optional<String> size, Optional<String> user) {
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Path image;
        private Optional<String> model = Optional.empty();
        private Optional<Integer> n = Optional.empty();
        private Optional<String> responseFormat = Optional.empty();
        private Optional<String> size = Optional.empty();
        private Optional<String> user = Optional.empty();

        public Builder image(Path image) {
            this.image = image;
            return this;
        }

        public Builder model(String model) {
            this.model = Optional.of(model);
            return this;
        }

        public Builder model(OpenAIModel model) {
            this.model = Optional.of(model.getId());
            return this;
        }

        public Builder n(int n) {
            this.n = Optional.of(n);
            return this;
        }

        public Builder responseFormat(String responseFormat) {
            this.responseFormat = Optional.of(responseFormat);
            return this;
        }

        public Builder size(String size) {
            this.size = Optional.of(size);
            return this;
        }

        public Builder user(String user) {
            this.user = Optional.of(user);
            return this;
        }

        public CreateImageVariationRequest build() {
            return new CreateImageVariationRequest(this.image, this.model, this.n, this.responseFormat, this.size, this.user);
        }
    }
}

