/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.OpenAIModel;
import java.util.Optional;

public record CreateImageRequest(String prompt, Optional<String> model, Optional<Integer> n, Optional<String> quality, Optional<String> responseFormat, Optional<String> size, Optional<String> style, Optional<String> user) {
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String prompt;
        private Optional<String> model = Optional.empty();
        private Optional<Integer> n = Optional.empty();
        private Optional<String> quality = Optional.empty();
        private Optional<String> responseFormat = Optional.empty();
        private Optional<String> size = Optional.empty();
        private Optional<String> style = Optional.empty();
        private Optional<String> user = Optional.empty();

        public Builder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public Builder model(String model) {
            this.model = Optional.of(model);
            return this;
        }

        public Builder model(OpenAIModel model) {
            this.model = Optional.of(model.getId());
            return this;
        }

        public Builder n(int n) {
            this.n = Optional.of(n);
            return this;
        }

        public Builder quality(String quality) {
            this.quality = Optional.of(quality);
            return this;
        }

        public Builder responseFormat(String responseFormat) {
            this.responseFormat = Optional.of(responseFormat);
            return this;
        }

        public Builder size(String size) {
            this.size = Optional.of(size);
            return this;
        }

        public Builder style(String style) {
            this.style = Optional.of(style);
            return this;
        }

        public Builder user(String user) {
            this.user = Optional.of(user);
            return this;
        }

        public CreateImageRequest build() {
            return new CreateImageRequest(this.prompt, this.model, this.n, this.quality, this.responseFormat, this.size, this.style, this.user);
        }
    }
}

