/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.ChatMessage;
import io.github.stefanbratanov.jvm.openai.OpenAIModel;
import io.github.stefanbratanov.jvm.openai.ResponseFormat;
import io.github.stefanbratanov.jvm.openai.Tool;
import io.github.stefanbratanov.jvm.openai.ToolChoice;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public record CreateChatCompletionRequest(List<ChatMessage> messages, String model, Optional<Double> frequencyPenalty, Optional<Map<Integer, Integer>> logitBias, Optional<Boolean> logprobs, Optional<Integer> topLogprobs, Optional<Integer> maxTokens, Optional<Integer> n, Optional<Double> presencePenalty, Optional<ResponseFormat> responseFormat, Optional<Integer> seed, Optional<String> serviceTier, Optional<List<String>> stop, Optional<Boolean> stream, Optional<StreamOptions> streamOptions, Optional<Double> temperature, Optional<Double> topP, Optional<List<Tool>> tools, Optional<Object> toolChoice, Optional<Boolean> parallelToolCalls, Optional<String> user) {
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private static final String DEFAULT_MODEL = OpenAIModel.GPT_3_5_TURBO.getId();
        private final List<ChatMessage> messages = new LinkedList<ChatMessage>();
        private String model = DEFAULT_MODEL;
        private Optional<Double> frequencyPenalty = Optional.empty();
        private Optional<Map<Integer, Integer>> logitBias = Optional.empty();
        private Optional<Boolean> logprobs = Optional.empty();
        private Optional<Integer> topLogprobs = Optional.empty();
        private Optional<Integer> maxTokens = Optional.empty();
        private Optional<Integer> n = Optional.empty();
        private Optional<Double> presencePenalty = Optional.empty();
        private Optional<ResponseFormat> responseFormat = Optional.empty();
        private Optional<Integer> seed = Optional.empty();
        private Optional<String> serviceTier = Optional.empty();
        private final List<String> stop = new LinkedList<String>();
        private Optional<Boolean> stream = Optional.empty();
        private Optional<StreamOptions> streamOptions = Optional.empty();
        private Optional<Double> temperature = Optional.empty();
        private Optional<Double> topP = Optional.empty();
        private final List<Tool> tools = new LinkedList<Tool>();
        private Optional<Object> toolChoice = Optional.empty();
        private Optional<Boolean> parallelToolCalls = Optional.empty();
        private Optional<String> user = Optional.empty();

        public Builder message(ChatMessage message) {
            this.messages.add(message);
            return this;
        }

        public Builder messages(List<ChatMessage> messages) {
            this.messages.addAll(messages);
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder model(OpenAIModel model) {
            this.model = model.getId();
            return this;
        }

        public Builder frequencyPenalty(double frequencyPenalty) {
            this.frequencyPenalty = Optional.of(frequencyPenalty);
            return this;
        }

        public Builder logitBias(Map<Integer, Integer> logitBias) {
            this.logitBias = Optional.of(logitBias);
            return this;
        }

        public Builder logprobs(boolean logprobs) {
            this.logprobs = Optional.of(logprobs);
            return this;
        }

        public Builder topLogprobs(int topLogprobs) {
            this.topLogprobs = Optional.of(topLogprobs);
            return this;
        }

        public Builder maxTokens(int maxTokens) {
            this.maxTokens = Optional.of(maxTokens);
            return this;
        }

        public Builder n(int n) {
            this.n = Optional.of(n);
            return this;
        }

        public Builder presencePenalty(double presencePenalty) {
            this.presencePenalty = Optional.of(presencePenalty);
            return this;
        }

        public Builder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = Optional.of(responseFormat);
            return this;
        }

        public Builder seed(int seed) {
            this.seed = Optional.of(seed);
            return this;
        }

        public Builder serviceTier(String serviceTier) {
            this.serviceTier = Optional.of(serviceTier);
            return this;
        }

        public Builder stop(String ... stop) {
            this.stop.addAll(Arrays.asList(stop));
            return this;
        }

        public Builder stream(boolean stream) {
            this.stream = Optional.of(stream);
            return this;
        }

        public Builder streamOptions(StreamOptions streamOptions) {
            this.streamOptions = Optional.of(streamOptions);
            return this;
        }

        public Builder temperature(double temperature) {
            this.temperature = Optional.of(temperature);
            return this;
        }

        public Builder topP(double topP) {
            this.topP = Optional.of(topP);
            return this;
        }

        public Builder tool(Tool tool) {
            this.tools.add(tool);
            return this;
        }

        public Builder tools(List<Tool> tools) {
            this.tools.addAll(tools);
            return this;
        }

        public Builder toolChoice(String toolChoice) {
            this.toolChoice = Optional.of(toolChoice);
            return this;
        }

        public Builder parallelToolCalls(boolean parallelToolCalls) {
            this.parallelToolCalls = Optional.of(parallelToolCalls);
            return this;
        }

        public Builder toolChoice(ToolChoice toolChoice) {
            this.toolChoice = Optional.of(toolChoice);
            return this;
        }

        public Builder user(String user) {
            this.user = Optional.of(user);
            return this;
        }

        public CreateChatCompletionRequest build() {
            return new CreateChatCompletionRequest(List.copyOf(this.messages), this.model, this.frequencyPenalty, this.logitBias, this.logprobs, this.topLogprobs, this.maxTokens, this.n, this.presencePenalty, this.responseFormat, this.seed, this.serviceTier, this.stop.isEmpty() ? Optional.empty() : Optional.of(List.copyOf(this.stop)), this.stream, this.streamOptions, this.temperature, this.topP, this.tools.isEmpty() ? Optional.empty() : Optional.of(List.copyOf(this.tools)), this.toolChoice, this.parallelToolCalls, this.user);
        }
    }

    public record StreamOptions(Boolean includeUsage) {
        public static StreamOptions withUsageIncluded() {
            return new StreamOptions(true);
        }
    }
}

