/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import java.util.Map;
import java.util.Optional;

public record CreateBatchRequest(String inputFileId, String endpoint, String completionWindow, Optional<Map<String, String>> metadata) {
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String inputFileId;
        private String endpoint;
        private String completionWindow;
        private Optional<Map<String, String>> metadata = Optional.empty();

        public Builder inputFileId(String inputFileId) {
            this.inputFileId = inputFileId;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder completionWindow(String completionWindow) {
            this.completionWindow = completionWindow;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = Optional.of(metadata);
            return this;
        }

        public CreateBatchRequest build() {
            return new CreateBatchRequest(this.inputFileId, this.endpoint, this.completionWindow, this.metadata);
        }
    }
}

