/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.AssistantsResponseFormat;
import io.github.stefanbratanov.jvm.openai.OpenAIModel;
import io.github.stefanbratanov.jvm.openai.Tool;
import io.github.stefanbratanov.jvm.openai.ToolResources;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public record CreateAssistantRequest(String model, Optional<String> name, Optional<String> description, Optional<String> instructions, Optional<List<Tool>> tools, Optional<ToolResources> toolResources, Optional<Map<String, String>> metadata, Optional<Double> temperature, Optional<Double> topP, Optional<AssistantsResponseFormat> responseFormat) {
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private static final String DEFAULT_MODEL = OpenAIModel.GPT_4.getId();
        private String model = DEFAULT_MODEL;
        private Optional<String> name = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> instructions = Optional.empty();
        private final List<Tool> tools = new LinkedList<Tool>();
        private Optional<ToolResources> toolResources = Optional.empty();
        private Optional<Map<String, String>> metadata = Optional.empty();
        private Optional<Double> temperature = Optional.empty();
        private Optional<Double> topP = Optional.empty();
        private Optional<AssistantsResponseFormat> responseFormat = Optional.empty();

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder model(OpenAIModel model) {
            this.model = model.getId();
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        public Builder instructions(String instructions) {
            this.instructions = Optional.of(instructions);
            return this;
        }

        public Builder tool(Tool tool) {
            this.tools.add(tool);
            return this;
        }

        public Builder tools(List<Tool> tools) {
            this.tools.addAll(tools);
            return this;
        }

        public Builder toolResources(ToolResources toolResources) {
            this.toolResources = Optional.of(toolResources);
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = Optional.of(metadata);
            return this;
        }

        public Builder temperature(double temperature) {
            this.temperature = Optional.of(temperature);
            return this;
        }

        public Builder topP(double topP) {
            this.topP = Optional.of(topP);
            return this;
        }

        public Builder responseFormat(AssistantsResponseFormat responseFormat) {
            this.responseFormat = Optional.of(responseFormat);
            return this;
        }

        public CreateAssistantRequest build() {
            return new CreateAssistantRequest(this.model, this.name, this.description, this.instructions, this.tools.isEmpty() ? Optional.empty() : Optional.of(List.copyOf(this.tools)), this.toolResources, this.metadata, this.temperature, this.topP, this.responseFormat);
        }
    }
}

