/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", include=JsonTypeInfo.As.EXISTING_PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AutoChunkingStrategy.class, name="auto"), @JsonSubTypes.Type(value=StaticChunkingStrategy.class, name="static"), @JsonSubTypes.Type(value=OtherChunkingStrategy.class, name="other")})
public interface ChunkingStrategy {
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String type();

    public static AutoChunkingStrategy autoChunkingStrategy() {
        return new AutoChunkingStrategy();
    }

    public static StaticChunkingStrategy staticChunkingStrategy(int maxChunkSizeTokens, int chunkOverlapTokens) {
        return new StaticChunkingStrategy(new StaticChunkingStrategy.Static(maxChunkSizeTokens, chunkOverlapTokens));
    }

    public static OtherChunkingStrategy otherChunkingStrategy() {
        return new OtherChunkingStrategy();
    }

    public record AutoChunkingStrategy() implements ChunkingStrategy
    {
        @Override
        public String type() {
            return "auto";
        }
    }

    public record StaticChunkingStrategy(@JsonProperty(value="static") Static staticVal) implements ChunkingStrategy
    {
        @Override
        public String type() {
            return "static";
        }

        public record Static(int maxChunkSizeTokens, int chunkOverlapTokens) {
        }
    }

    public record OtherChunkingStrategy() implements ChunkingStrategy
    {
        @Override
        public String type() {
            return "other";
        }
    }
}

