/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.Endpoint;
import io.github.stefanbratanov.jvm.openai.MultipartBodyPublisher;
import io.github.stefanbratanov.jvm.openai.OpenAIClient;
import io.github.stefanbratanov.jvm.openai.SpeechRequest;
import io.github.stefanbratanov.jvm.openai.TranscriptionRequest;
import io.github.stefanbratanov.jvm.openai.TranslationRequest;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public final class AudioClient
extends OpenAIClient {
    private final URI baseUrl;

    AudioClient(URI baseUrl, String[] authenticationHeaders, HttpClient httpClient, Optional<Duration> requestTimeout) {
        super(authenticationHeaders, httpClient, requestTimeout);
        this.baseUrl = baseUrl;
    }

    public void createSpeech(SpeechRequest request, Path output) {
        this.createParentDirectories(output);
        HttpRequest httpRequest = this.createSpeechPostRequest(request);
        this.sendHttpRequest(httpRequest, HttpResponse.BodyHandlers.ofFile(output));
    }

    public CompletableFuture<Void> createSpeechAsync(SpeechRequest request, Path output) {
        this.createParentDirectories(output);
        HttpRequest httpRequest = this.newHttpRequestBuilder("Content-Type", "application/json").uri(this.baseUrl.resolve(Endpoint.SPEECH.getPath())).POST(this.createBodyPublisher(request)).build();
        return this.sendHttpRequestAsync(httpRequest, HttpResponse.BodyHandlers.ofFile(output)).thenApply(httpResponse -> null);
    }

    public String createTranscript(TranscriptionRequest request) {
        HttpRequest httpRequest = this.createTranscriptPostRequest(request);
        return this.sendHttpRequest(httpRequest, HttpResponse.BodyHandlers.ofString()).body();
    }

    public CompletableFuture<String> createTranscriptAsync(TranscriptionRequest request) {
        HttpRequest httpRequest = this.createTranscriptPostRequest(request);
        return this.sendHttpRequestAsync(httpRequest, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body);
    }

    public String createTranslation(TranslationRequest request) {
        HttpRequest httpRequest = this.createTranslationPostRequest(request);
        return this.sendHttpRequest(httpRequest, HttpResponse.BodyHandlers.ofString()).body();
    }

    public CompletableFuture<String> createTranslationAsync(TranslationRequest request) {
        HttpRequest httpRequest = this.createTranslationPostRequest(request);
        return this.sendHttpRequestAsync(httpRequest, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body);
    }

    private void createParentDirectories(Path path) {
        try {
            Path parentPath = path.getParent();
            if (parentPath != null) {
                Files.createDirectories(parentPath, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private HttpRequest createSpeechPostRequest(SpeechRequest request) {
        return this.newHttpRequestBuilder("Content-Type", "application/json").uri(this.baseUrl.resolve(Endpoint.SPEECH.getPath())).POST(this.createBodyPublisher(request)).build();
    }

    private HttpRequest createTranscriptPostRequest(TranscriptionRequest request) {
        MultipartBodyPublisher.Builder multipartBodyPublisherBuilder = MultipartBodyPublisher.newBuilder().filePart("file", request.file()).textPart("model", request.model());
        request.language().ifPresent(language -> multipartBodyPublisherBuilder.textPart("language", language));
        request.prompt().ifPresent(prompt -> multipartBodyPublisherBuilder.textPart("prompt", prompt));
        request.responseFormat().ifPresent(responseFormat -> multipartBodyPublisherBuilder.textPart("response_format", responseFormat));
        request.temperature().ifPresent(temperature -> multipartBodyPublisherBuilder.textPart("temperature", temperature));
        request.timestampGranularities().ifPresent(timestampGranularities -> multipartBodyPublisherBuilder.textPart("timestamp_granularities", timestampGranularities));
        MultipartBodyPublisher multipartBodyPublisher = multipartBodyPublisherBuilder.build();
        return this.newHttpRequestBuilder("Content-Type", multipartBodyPublisher.getContentTypeHeader()).uri(this.baseUrl.resolve(Endpoint.TRANSCRIPTION.getPath())).POST(multipartBodyPublisher).build();
    }

    private HttpRequest createTranslationPostRequest(TranslationRequest request) {
        MultipartBodyPublisher.Builder multipartBodyPublisherBuilder = MultipartBodyPublisher.newBuilder().filePart("file", request.file()).textPart("model", request.model());
        request.prompt().ifPresent(prompt -> multipartBodyPublisherBuilder.textPart("prompt", prompt));
        request.responseFormat().ifPresent(responseFormat -> multipartBodyPublisherBuilder.textPart("response_format", responseFormat));
        request.temperature().ifPresent(temperature -> multipartBodyPublisherBuilder.textPart("temperature", temperature));
        MultipartBodyPublisher multipartBodyPublisher = multipartBodyPublisherBuilder.build();
        return this.newHttpRequestBuilder("Content-Type", multipartBodyPublisher.getContentTypeHeader()).uri(this.baseUrl.resolve(Endpoint.TRANSLATION.getPath())).POST(multipartBodyPublisher).build();
    }
}

