/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import io.github.stefanbratanov.jvm.openai.AssistantsToolChoice;
import io.github.stefanbratanov.jvm.openai.ToolChoice;
import java.io.IOException;

class AssistantsToolChoiceDeserializer
extends StdDeserializer<AssistantsToolChoice> {
    AssistantsToolChoiceDeserializer() {
        super(AssistantsToolChoice.class);
    }

    public AssistantsToolChoice deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (node.isTextual()) {
            return new AssistantsToolChoice.StringToolChoice(node.asText());
        }
        if (node.isObject()) {
            String type = node.get("type").asText();
            ToolChoice.Function function = null;
            if (node.has("function")) {
                JsonNode functionNode = node.get("function");
                function = new ToolChoice.Function(functionNode.get("name").asText());
            }
            return new ToolChoice(type, function);
        }
        throw InvalidFormatException.from((JsonParser)p, (String)"Expected String or Object", (Object)node, AssistantsToolChoice.class);
    }
}

