/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import io.github.stefanbratanov.jvm.openai.AssistantsResponseFormat;
import io.github.stefanbratanov.jvm.openai.ResponseFormat;
import java.io.IOException;

class AssistantsResponseFormatDeserializer
extends StdDeserializer<AssistantsResponseFormat> {
    AssistantsResponseFormatDeserializer() {
        super(AssistantsResponseFormat.class);
    }

    public AssistantsResponseFormat deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (node.isTextual()) {
            return new AssistantsResponseFormat.StringResponseFormat(node.asText());
        }
        if (node.isObject()) {
            String type = node.get("type").asText();
            return new ResponseFormat(type);
        }
        throw InvalidFormatException.from((JsonParser)p, (String)"Expected String or Object", (Object)node, AssistantsResponseFormat.class);
    }
}

