/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.Assistant;
import io.github.stefanbratanov.jvm.openai.CreateAssistantRequest;
import io.github.stefanbratanov.jvm.openai.DeletionStatus;
import io.github.stefanbratanov.jvm.openai.Endpoint;
import io.github.stefanbratanov.jvm.openai.ModifyAssistantRequest;
import io.github.stefanbratanov.jvm.openai.OpenAIAssistantsClient;
import io.github.stefanbratanov.jvm.openai.PaginationQueryParameters;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public final class AssistantsClient
extends OpenAIAssistantsClient {
    private final URI baseUrl;

    AssistantsClient(URI baseUrl, String[] authenticationHeaders, HttpClient httpClient, Optional<Duration> requestTimeout) {
        super(authenticationHeaders, httpClient, requestTimeout);
        this.baseUrl = baseUrl;
    }

    public Assistant createAssistant(CreateAssistantRequest request) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.ASSISTANTS.getPath())).POST(this.createBodyPublisher(request)).build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), Assistant.class);
    }

    public PaginatedAssistants listAssistants(PaginationQueryParameters paginationQueryParameters) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.ASSISTANTS.getPath() + this.createQueryParameters(paginationQueryParameters))).GET().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), PaginatedAssistants.class);
    }

    public Assistant retrieveAssistant(String assistantId) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.ASSISTANTS.getPath() + "/" + assistantId)).GET().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), Assistant.class);
    }

    public Assistant modifyAssistant(String assistantId, ModifyAssistantRequest request) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.ASSISTANTS.getPath() + "/" + assistantId)).POST(this.createBodyPublisher(request)).build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), Assistant.class);
    }

    public DeletionStatus deleteAssistant(String assistantId) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.ASSISTANTS.getPath() + "/" + assistantId)).DELETE().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), DeletionStatus.class);
    }

    public record PaginatedAssistants(List<Assistant> data, String firstId, String lastId, boolean hasMore) {
    }
}

