/*
 * Decompiled with CFR 0.152.
 */
package faker.com.fasterxml.jackson.module.kotlin;

import faker.com.fasterxml.jackson.databind.BeanDescription;
import faker.com.fasterxml.jackson.databind.JavaType;
import faker.com.fasterxml.jackson.databind.JsonSerializer;
import faker.com.fasterxml.jackson.databind.SerializationConfig;
import faker.com.fasterxml.jackson.databind.ser.Serializers;
import faker.com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import faker.com.fasterxml.jackson.module.kotlin.UByteSerializer;
import faker.com.fasterxml.jackson.module.kotlin.UIntSerializer;
import faker.com.fasterxml.jackson.module.kotlin.ULongSerializer;
import faker.com.fasterxml.jackson.module.kotlin.UShortSerializer;
import faker.com.fasterxml.jackson.module.kotlin.ValueClassSerializer;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lfaker/com/fasterxml/jackson/module/kotlin/KotlinSerializers;", "Lfaker/com/fasterxml/jackson/databind/ser/Serializers$Base;", "()V", "findSerializer", "Lfaker/com/fasterxml/jackson/databind/JsonSerializer;", "config", "Lfaker/com/fasterxml/jackson/databind/SerializationConfig;", "type", "Lfaker/com/fasterxml/jackson/databind/JavaType;", "beanDesc", "Lfaker/com/fasterxml/jackson/databind/BeanDescription;", "jackson-module-kotlin"})
public final class KotlinSerializers
extends Serializers.Base {
    @Override
    @Nullable
    public JsonSerializer<?> findSerializer(@Nullable SerializationConfig config2, @NotNull JavaType type, @Nullable BeanDescription beanDesc) {
        JsonSerializer jsonSerializer;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Class<?> rawClass = type.getRawClass();
        if (UByte.class.isAssignableFrom(rawClass)) {
            jsonSerializer = UByteSerializer.INSTANCE;
        } else if (UShort.class.isAssignableFrom(rawClass)) {
            jsonSerializer = UShortSerializer.INSTANCE;
        } else if (UInt.class.isAssignableFrom(rawClass)) {
            jsonSerializer = UIntSerializer.INSTANCE;
        } else if (ULong.class.isAssignableFrom(rawClass)) {
            jsonSerializer = ULongSerializer.INSTANCE;
        } else {
            Intrinsics.checkNotNullExpressionValue(rawClass, (String)"rawClass");
            jsonSerializer = ExtensionsKt.isUnboxableValueClass(rawClass) ? (JsonSerializer)ValueClassSerializer.Companion.from(rawClass) : null;
        }
        return jsonSerializer;
    }
}

