/*
 * Decompiled with CFR 0.152.
 */
package com.lehman.knit;

import com.lehman.knit.dwFile;
import com.lehman.knit.knitParser;
import com.lehman.knit.markdownDwDocWriterImpl;
import com.lehman.knit.util;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="knit", defaultPhase=LifecyclePhase.COMPILE)
public class Main
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter(property="generate")
    boolean generate = true;
    @Parameter(property="files")
    String[] files;
    @Parameter(property="directories")
    String[] directories = new String[]{"src/main/resources/dw"};
    @Parameter(property="singleOutputFile")
    boolean singleOutputFile = true;
    @Parameter(property="outputFile")
    String outputFile = "target/knit-doc.md";
    @Parameter(property="outputHeaderText")
    String outputHeaderText = "";
    @Parameter(property="writeHeaderTable")
    boolean writeHeaderTable = false;
    @Parameter(property="moduleList")
    String[] moduleList = new String[0];

    public void setDirectories(String[] Directories) {
        if (Directories.length > 0) {
            this.directories = Directories;
        }
    }

    public void setFiles(String[] Files) {
        this.files = Files;
    }

    public void setModuleList(String[] ModuleList) {
        this.moduleList = ModuleList;
    }

    public static void main(String[] args) throws Exception {
        ArrayList<dwFile> parsedFiles = new ArrayList<dwFile>();
        Main.parseDirectory("dw", "dw", parsedFiles);
        markdownDwDocWriterImpl writer = new markdownDwDocWriterImpl();
        String doc = writer.writeDoc(parsedFiles);
        System.out.println(doc);
    }

    public static void parseDirectory(String rootDirName, String dirName, ArrayList<dwFile> parsedFiles) throws Exception {
        knitParser parser = new knitParser();
        File dir = new File(dirName);
        if (dir.isDirectory()) {
            for (String name : dir.list()) {
                String relName = dirName + "/" + name;
                File f = new File(relName);
                if (f.isFile() && relName.endsWith(".dwl")) {
                    parsedFiles.add(parser.parseFile(rootDirName, relName));
                    continue;
                }
                if (!f.isDirectory()) continue;
                Main.parseDirectory(rootDirName, relName, parsedFiles);
            }
        } else {
            throw new Exception("Provided directory '" + dirName + "' isn't a directory.");
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.printAbout();
        System.out.println("Running Knit doc generator ...");
        if (this.generate) {
            if (!this.singleOutputFile) {
                System.err.println("Error: knit-maven-plugin <singleOutputFile> is set to false but only single file is currently implemented.");
                System.exit(1);
            }
            if (this.files.length > 0 || this.directories.length > 0) {
                this.writeDwFile();
            } else {
                System.err.println("Error: knit-maven-plugin <srcFiles> or <srcDirectories> aren't specified.");
                System.exit(1);
            }
        } else {
            System.out.println("Info: knit-maven-plugin skipping doc generation. (generate=false)");
        }
    }

    private void writeDwFile() {
        ArrayList<dwFile> parsedFiles = new ArrayList<dwFile>();
        try {
            for (String dir : this.directories) {
                Main.parseDirectory(dir, dir, parsedFiles);
            }
            knitParser parser = new knitParser();
            for (String fname : this.files) {
                File f = new File(fname);
                parsedFiles.add(parser.parseFile(f.getParent(), fname));
            }
            markdownDwDocWriterImpl writer = new markdownDwDocWriterImpl();
            String doc = "";
            if (!this.outputHeaderText.equals("")) {
                doc = doc + this.outputHeaderText + "\n\n";
            }
            if (this.writeHeaderTable) {
                doc = doc + writer.writeHeaderTable(parsedFiles, Arrays.asList(this.moduleList));
            }
            doc = doc + writer.writeDoc(parsedFiles, Arrays.asList(this.moduleList));
            util.write(this.outputFile, doc, false);
            System.out.println("Document has been written to '" + this.outputFile + "'.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Error: knit-maven-plugin parse failed.");
            System.exit(1);
        }
    }

    private void printAbout() {
        String out = "";
        out = out + " __  __     __   __     __     ______      _____     ______     ______                            \n/\\ \\/ /    /\\ \"-.\\ \\   /\\ \\   /\\__  _\\    /\\  __-.  /\\  __ \\   /\\  ___\\                           \n\\ \\  _\"-.  \\ \\ \\-.  \\  \\ \\ \\  \\/_/\\ \\/    \\ \\ \\/\\ \\ \\ \\ \\/\\ \\  \\ \\ \\____                          \n \\ \\_\\ \\_\\  \\ \\_\\\\\"\\_\\  \\ \\_\\    \\ \\_\\     \\ \\____-  \\ \\_____\\  \\ \\_____\\                         \n  \\/_/\\/_/   \\/_/ \\/_/   \\/_/     \\/_/      \\/____/   \\/_____/   \\/_____/                         \n                                                                                                  \n ______     ______     __   __     ______     ______     ______     ______   ______     ______    \n/\\  ___\\   /\\  ___\\   /\\ \"-.\\ \\   /\\  ___\\   /\\  == \\   /\\  __ \\   /\\__  _\\ /\\  __ \\   /\\  == \\   \n\\ \\ \\__ \\  \\ \\  __\\   \\ \\ \\-.  \\  \\ \\  __\\   \\ \\  __<   \\ \\  __ \\  \\/_/\\ \\/ \\ \\ \\/\\ \\  \\ \\  __<   \n \\ \\_____\\  \\ \\_____\\  \\ \\_\\\\\"\\_\\  \\ \\_____\\  \\ \\_\\ \\_\\  \\ \\_\\ \\_\\    \\ \\_\\  \\ \\_____\\  \\ \\_\\ \\_\\ \n  \\/_____/   \\/_____/   \\/_/ \\/_/   \\/_____/   \\/_/ /_/   \\/_/\\/_/     \\/_/   \\/_____/   \\/_/ /_/ \n                                                                                                  \n";
        out = out + "Knit 1.0 - DataWeave Document Generator\n";
        out = out + "Written By Austin Lehman\n";
        out = out + "austin@rosevillecode.com\n";
        out = out + "Copyright 2020 Roseville Code Inc.\n";
        System.out.println(out);
    }
}

