/*
 * Decompiled with CFR 0.152.
 */
package razerdp.util.animation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.util.Property;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import razerdp.util.animation.BaseAnimationConfig;

public class RotationConfig
extends BaseAnimationConfig<RotationConfig> {
    float from;
    float to;

    @Override
    void resetInternal() {
        this.to = 0.0f;
        this.from = 0.0f;
        this.pivot(0.5f, 0.5f);
    }

    public RotationConfig() {
        super(false, false);
        this.resetInternal();
    }

    RotationConfig(boolean resetParent, boolean resetInternal) {
        super(resetParent, resetInternal);
        this.resetInternal();
    }

    public RotationConfig from(float from) {
        this.from = from;
        return this;
    }

    public RotationConfig to(float to) {
        this.to = to;
        return this;
    }

    @Override
    protected Animation buildAnimation(boolean isRevert) {
        RotateAnimation rotateAnimation = new RotateAnimation(this.from, this.to, 1, this.pivotX, 1, this.pivotY);
        this.deploy((Animation)rotateAnimation);
        return rotateAnimation;
    }

    @Override
    protected Animator buildAnimator(boolean isRevert) {
        ObjectAnimator rotate = ObjectAnimator.ofFloat(null, (Property)View.ROTATION, (float[])new float[]{this.from, this.to});
        rotate.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                Object target = ((ObjectAnimator)animation).getTarget();
                if (target instanceof View) {
                    ((View)target).setPivotX((float)((View)target).getWidth() * RotationConfig.this.pivotX);
                    ((View)target).setPivotY((float)((View)target).getHeight() * RotationConfig.this.pivotY);
                }
            }
        });
        this.deploy((Animator)rotate);
        return rotate;
    }
}

