/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.data.transaction.ChainedTransactionManager;
import org.springframework.lang.Nullable;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.StringUtils;

public class MultiTransactionInterceptor
extends TransactionInterceptor {
    private final ConcurrentMap<TransactionManagerKey, TransactionManager> transactionManagerCache = new ConcurrentReferenceHashMap(4);
    private final String defaultTransactionManagerName = "allTransactionManager";

    public MultiTransactionInterceptor(TransactionAttributeSource transactionAttributeSource) {
        Assert.notNull((Object)transactionAttributeSource, (String)"Parameter 'transactionAttributeSource' must be required!");
        this.setTransactionAttributeSource(transactionAttributeSource);
    }

    @Nullable
    protected TransactionManager determineTransactionManager(@Nullable TransactionAttribute txAttr) {
        if (txAttr == null) {
            return this.getDefaultTransactionManager();
        }
        String qualifier = txAttr.getQualifier();
        if (StringUtils.hasText((String)qualifier)) {
            return this.getQualifiedTransactionManager(qualifier);
        }
        return this.getDefaultTransactionManager();
    }

    protected PlatformTransactionManager getDefaultTransactionManager() {
        return (PlatformTransactionManager)this.getBeanFactory().getBean("allTransactionManager", PlatformTransactionManager.class);
    }

    protected TransactionManager getQualifiedTransactionManager(String qualifier) {
        TransactionManagerKey transactionManagerKey = new TransactionManagerKey(qualifier);
        return this.transactionManagerCache.computeIfAbsent(transactionManagerKey, this::createQualifiedTransactionManager);
    }

    protected TransactionManager createQualifiedTransactionManager(TransactionManagerKey transactionManagerKey) {
        Set<String> transactionManagerNames = transactionManagerKey.getTransactionManagerNames();
        if (transactionManagerNames.size() == 1) {
            return this.getTransactionManagerBean(transactionManagerNames.iterator().next());
        }
        PlatformTransactionManager[] transactionManagers = (PlatformTransactionManager[])transactionManagerNames.stream().map(this::getTransactionManagerBean).toArray(PlatformTransactionManager[]::new);
        return new ChainedTransactionManager(transactionManagers);
    }

    private PlatformTransactionManager getTransactionManagerBean(String transactionManagerQualifier) {
        return (PlatformTransactionManager)BeanFactoryAnnotationUtils.qualifiedBeanOfType((BeanFactory)this.getBeanFactory(), PlatformTransactionManager.class, (String)transactionManagerQualifier);
    }

    public String getDefaultTransactionManagerName() {
        return "allTransactionManager";
    }

    protected ConcurrentMap<TransactionManagerKey, TransactionManager> getTransactionManagerCache() {
        return this.transactionManagerCache;
    }

    public static class TransactionManagerKey {
        public static final String TRANSACTION_MANAGER_QUALIFIER_SUFFIX = TransactionManager.class.getSimpleName();
        private final Set<String> transactionManagerNames;
        private final String transactionManagerQualifier;

        public TransactionManagerKey(String transactionManagerQualifier) {
            Set transactionManagerNames = Stream.of(transactionManagerQualifier.split(",")).filter(StringUtils::hasText).map(this::prepareTransactionManagerQualifier).sorted(String::compareTo).collect(Collectors.toCollection(LinkedHashSet::new));
            Assert.notEmpty((Collection)transactionManagerNames, (String)String.format("Illegal TransactionManager qualifier: %s, may be you need to check @Transactional#transactionManager()", transactionManagerQualifier));
            this.transactionManagerNames = Collections.unmodifiableSet(transactionManagerNames);
            this.transactionManagerQualifier = String.join((CharSequence)",", transactionManagerNames);
        }

        private String prepareTransactionManagerQualifier(String qualifier) {
            if (!(qualifier = qualifier.trim()).endsWith(TRANSACTION_MANAGER_QUALIFIER_SUFFIX)) {
                return qualifier + TRANSACTION_MANAGER_QUALIFIER_SUFFIX;
            }
            return qualifier;
        }

        public Set<String> getTransactionManagerNames() {
            return this.transactionManagerNames;
        }

        public String getTransactionManagerQualifier() {
            return this.transactionManagerQualifier;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TransactionManagerKey)) {
                return false;
            }
            TransactionManagerKey that = (TransactionManagerKey)o;
            return this.transactionManagerQualifier.equals(that.transactionManagerQualifier);
        }

        public int hashCode() {
            return Objects.hash(this.transactionManagerQualifier);
        }

        public String toString() {
            return this.transactionManagerQualifier;
        }
    }
}

