/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mds.mybatis;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.boot.autoconfigure.MybatisProperties;
import org.mybatis.spring.mapper.ClassPathMapperScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.mds.AbstractMdsComponentsRegistry;
import org.springframework.boot.autoconfigure.mds.MdsComponentBean;
import org.springframework.boot.autoconfigure.mds.MdsComponentBeans;
import org.springframework.boot.autoconfigure.mds.jdbc.MdsJdbcComponentType;
import org.springframework.boot.autoconfigure.mds.mybatis.MdsMybatisComponentConfig;
import org.springframework.boot.autoconfigure.mds.mybatis.MdsMybatisComponentType;
import org.springframework.boot.autoconfigure.mds.mybatis.MdsMybatisComponentsBuilder;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public class MdsMybatisComponentsRegistry
extends AbstractMdsComponentsRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MdsMybatisComponentsRegistry.class);
    protected final MdsMybatisComponentsBuilder mdsMybatisComponentsBuilder;

    public MdsMybatisComponentsRegistry(MdsMybatisComponentsBuilder mdsMybatisComponentsBuilder) {
        this.mdsMybatisComponentsBuilder = mdsMybatisComponentsBuilder;
    }

    @Override
    protected Set<MdsComponentBean> registerComponentBeans(BeanDefinitionRegistry registry, String database) {
        Set<MdsComponentBean> componentBeans = this.newComponentBeans();
        if (this.hasRequiredDataSource(database)) {
            LOGGER.debug("Prepare to dynamic register Multi-DataSource Mybatis components for Database({}).", (Object)database);
            componentBeans.addAll(this.registerSqlSessionFactoryBean(registry, database));
            componentBeans.addAll(this.registerSqlSessionTemplateBean(registry, database));
            componentBeans.addAll(this.registerMapperByMapperScanner(registry, database));
        }
        return componentBeans;
    }

    @Override
    protected void afterComponentsRegisterCompletion(AnnotationMetadata mdsAnnotationMetadata, BeanDefinitionRegistry registry, MdsComponentBeans mdsComponentBeans) {
        this.getMdsComponentsRegistrationLifecycles().forEach(lifecycle -> lifecycle.onMdsMybatisComponentsRegistered(mdsAnnotationMetadata, registry, mdsComponentBeans.clone()));
    }

    protected Set<MdsComponentBean> registerSqlSessionFactoryBean(BeanDefinitionRegistry registry, String database) {
        Set<MdsComponentBean> componentBeans = this.newComponentBeans();
        String sqlSessionFactoryBeanName = MdsMybatisComponentType.SQL_SESSION_FACTORY.getComponentBeanName(database);
        boolean componentExist = this.beanFactory.containsBean(sqlSessionFactoryBeanName);
        if (!componentExist) {
            BeanDefinition mybatisPropertiesDefinition = this.createMybatisPropertiesBeanDefinition(database);
            String mybatisPropertiesBeanName = MdsMybatisComponentType.MYBATIS_PROPERTIES.getComponentBeanName(database);
            registry.registerBeanDefinition(mybatisPropertiesBeanName, mybatisPropertiesDefinition);
            MybatisProperties mybatisProperties = (MybatisProperties)this.beanFactory.getBean(mybatisPropertiesBeanName, MdsMybatisComponentType.MYBATIS_PROPERTIES.getComponentBeanType());
            componentBeans.add(new MdsComponentBean(database, MdsMybatisComponentType.MYBATIS_PROPERTIES, mybatisPropertiesBeanName, mybatisProperties, true));
            LOGGER.debug("Dynamic register MybatisProperties[database = {}] bean ({}) successfully: {}", new Object[]{database, mybatisPropertiesBeanName, mybatisProperties});
            String dataSourceBeanName = MdsJdbcComponentType.DATASOURCE.getComponentBeanName(database);
            DataSource dataSource = (DataSource)this.beanFactory.getBean(dataSourceBeanName, MdsJdbcComponentType.DATASOURCE.getComponentBeanType());
            FactoryBean<SqlSessionFactory> sqlSessionFactoryBean = this.mdsMybatisComponentsBuilder.buildSqlSessionFactoryBean(database, dataSource, mybatisProperties);
            BeanDefinition sqlSessionFactoryBeanDefinition = this.createBeanDefinition(sqlSessionFactoryBean, null);
            registry.registerBeanDefinition(sqlSessionFactoryBeanName, sqlSessionFactoryBeanDefinition);
            SqlSessionFactory sqlSessionFactory = (SqlSessionFactory)this.beanFactory.getBean(sqlSessionFactoryBeanName, MdsMybatisComponentType.SQL_SESSION_FACTORY.getComponentBeanType());
            LOGGER.debug("Dynamic register SqlSessionFactory[database = {}] bean ({}) successfully: {}", new Object[]{database, sqlSessionFactoryBeanName, sqlSessionFactory});
        }
        componentBeans.add(new MdsComponentBean(database, MdsMybatisComponentType.SQL_SESSION_FACTORY, sqlSessionFactoryBeanName, this.beanFactory.getBean(sqlSessionFactoryBeanName, MdsMybatisComponentType.SQL_SESSION_FACTORY.getComponentBeanType()), !componentExist));
        return componentBeans;
    }

    protected BeanDefinition createMybatisPropertiesBeanDefinition(String database) {
        MybatisProperties mybatisProperties = (MybatisProperties)MdsMybatisComponentConfig.MYBATIS.getBoundedConfigProperties((Environment)this.environment, database);
        if (mybatisProperties == null) {
            mybatisProperties = (MybatisProperties)MdsMybatisComponentConfig.MYBATIS.getBoundedConfigProperties((Environment)this.environment, null);
        }
        mybatisProperties = mybatisProperties != null ? mybatisProperties : (MybatisProperties)MdsMybatisComponentConfig.MYBATIS.newDefaultConfigProperties();
        return this.createBeanDefinition(mybatisProperties, MybatisProperties.class);
    }

    protected Set<MdsComponentBean> registerSqlSessionTemplateBean(BeanDefinitionRegistry registry, String database) {
        Set<MdsComponentBean> componentBeans = this.newComponentBeans();
        String sqlSessionTemplateBeanName = MdsMybatisComponentType.SQL_SESSION_TEMPLATE.getComponentBeanName(database);
        boolean componentExist = this.beanFactory.containsBean(sqlSessionTemplateBeanName);
        if (!componentExist) {
            String sqlSessionFactoryBeanName = MdsMybatisComponentType.SQL_SESSION_FACTORY.getComponentBeanName(database);
            SqlSessionFactory sqlSessionFactory = (SqlSessionFactory)this.beanFactory.getBean(sqlSessionFactoryBeanName, MdsMybatisComponentType.SQL_SESSION_FACTORY.getComponentBeanType());
            String mybatisPropertiesBeanName = MdsMybatisComponentType.MYBATIS_PROPERTIES.getComponentBeanName(database);
            MybatisProperties mybatisProperties = (MybatisProperties)this.beanFactory.getBean(mybatisPropertiesBeanName, MdsMybatisComponentType.MYBATIS_PROPERTIES.getComponentBeanType());
            ExecutorType executorType = mybatisProperties.getExecutorType();
            SqlSessionTemplate sqlSessionTemplate = executorType != null ? new SqlSessionTemplate(sqlSessionFactory, executorType) : new SqlSessionTemplate(sqlSessionFactory);
            BeanDefinition sqlSessionTemplateBeanDefinition = this.createBeanDefinition(sqlSessionTemplate, MdsMybatisComponentType.SQL_SESSION_TEMPLATE.getComponentBeanType());
            registry.registerBeanDefinition(sqlSessionTemplateBeanName, sqlSessionTemplateBeanDefinition);
            LOGGER.debug("Dynamic register SqlSessionTemplate[database = {}] bean ({}) successfully: {}", new Object[]{database, sqlSessionTemplateBeanName, sqlSessionTemplate});
        }
        componentBeans.add(new MdsComponentBean(database, MdsMybatisComponentType.SQL_SESSION_TEMPLATE, sqlSessionTemplateBeanName, this.beanFactory.getBean(sqlSessionTemplateBeanName, MdsMybatisComponentType.SQL_SESSION_TEMPLATE.getComponentBeanType()), !componentExist));
        return componentBeans;
    }

    protected Set<MdsComponentBean> registerMapperByMapperScanner(BeanDefinitionRegistry registry, String database) {
        ClassPathMapperScanner classPathMapperScanner = this.mdsMybatisComponentsBuilder.buildClassPathMapperScanner(database, registry);
        classPathMapperScanner.registerFilters();
        Set<MdsComponentBean> componentBeans = this.scanMappers(registry, database, classPathMapperScanner);
        LOGGER.debug("Dynamic register XxxMapper[database = {}] beans(Total {}) successfully", (Object)database, (Object)componentBeans.size());
        return componentBeans;
    }

    protected Set<MdsComponentBean> scanMappers(BeanDefinitionRegistry registry, String database, ClassPathMapperScanner classPathMapperScanner) {
        Set mapperBeanDefinitions = classPathMapperScanner.doScan(this.mdsMybatisComponentsBuilder.getMapperScanBasePackages());
        AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)registry);
        return mapperBeanDefinitions.stream().map(beanDefinition -> {
            String mapperBeanName = beanDefinition.getBeanName();
            return new MdsComponentBean(database, MdsMybatisComponentType.MYBATIS_MAPPER, mapperBeanName, this.beanFactory.getBean(mapperBeanName), true);
        }).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public final int getOrder() {
        return 2147482647;
    }
}

