/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mds.mybatis;

import java.util.List;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.boot.autoconfigure.MybatisProperties;
import org.mybatis.spring.mapper.ClassPathMapperScanner;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.mds.DatabasedBeanNameGenerator;
import org.springframework.boot.autoconfigure.mds.MdsComponentsBuilderSupport;
import org.springframework.boot.autoconfigure.mds.NamedDatabase;
import org.springframework.boot.autoconfigure.mds.mybatis.DatabasedMapperExcludeFilter;
import org.springframework.boot.autoconfigure.mds.mybatis.MdsMybatisComponentType;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.StringUtils;

public abstract class MdsMybatisComponentsBuilder
extends MdsComponentsBuilderSupport {
    public abstract FactoryBean<SqlSessionFactory> buildSqlSessionFactoryBean(String var1, DataSource var2, MybatisProperties var3);

    public ClassPathMapperScanner buildClassPathMapperScanner(String database, BeanDefinitionRegistry registry) {
        String sqlSessionFactoryBeanName = MdsMybatisComponentType.SQL_SESSION_FACTORY.getComponentBeanName(database);
        ClassPathMapperScanner classPathMapperScanner = new ClassPathMapperScanner(registry);
        classPathMapperScanner.setAddToConfig(true);
        classPathMapperScanner.setAnnotationClass(NamedDatabase.class);
        classPathMapperScanner.setSqlSessionFactoryBeanName(sqlSessionFactoryBeanName);
        classPathMapperScanner.setResourceLoader(this.getResourceLoader());
        classPathMapperScanner.setEnvironment((Environment)this.getEnvironment());
        classPathMapperScanner.setBeanNameGenerator((BeanNameGenerator)new DatabasedBeanNameGenerator(database));
        classPathMapperScanner.addExcludeFilter((TypeFilter)new DatabasedMapperExcludeFilter(database));
        return classPathMapperScanner;
    }

    protected String[] getMapperScanBasePackages() {
        List basePackages = AutoConfigurationPackages.get((BeanFactory)this.getBeanFactory());
        return basePackages.toArray(new String[0]);
    }

    protected Resource getConfigLocation(String configLocation) {
        if (StringUtils.hasText((String)configLocation)) {
            Resource resource = this.getResourceLoader().getResource(configLocation);
            return resource.exists() ? resource : null;
        }
        return null;
    }
}

