/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mds.mybatis;

import java.beans.FeatureDescriptor;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.TypeHandler;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer;
import org.mybatis.spring.boot.autoconfigure.MybatisProperties;
import org.mybatis.spring.boot.autoconfigure.SpringBootVFS;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.boot.autoconfigure.mds.mybatis.MdsMybatisComponentsBuilder;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DefaultMdsMybatisComponentsBuilder
extends MdsMybatisComponentsBuilder {
    @Override
    public FactoryBean<SqlSessionFactory> buildSqlSessionFactoryBean(String database, DataSource dataSource, MybatisProperties properties) {
        List<TypeHandler> typeHandlers;
        DatabaseIdProvider databaseIdProvider;
        SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
        sqlSessionFactoryBean.setDataSource(dataSource);
        sqlSessionFactoryBean.setVfs(SpringBootVFS.class);
        this.applyConfiguration(sqlSessionFactoryBean, database, properties);
        List<Interceptor> interceptors = this.getAgreedNamingBeans(database, Interceptor.class);
        if (!CollectionUtils.isEmpty(interceptors)) {
            sqlSessionFactoryBean.setPlugins(interceptors.toArray(new Interceptor[0]));
        }
        if ((databaseIdProvider = this.getAgreedNamingBean(database, DatabaseIdProvider.class)) != null) {
            sqlSessionFactoryBean.setDatabaseIdProvider(databaseIdProvider);
        }
        if (StringUtils.hasLength((String)properties.getTypeAliasesPackage())) {
            sqlSessionFactoryBean.setTypeAliasesPackage(properties.getTypeAliasesPackage());
        }
        if (properties.getTypeAliasesSuperType() != null) {
            sqlSessionFactoryBean.setTypeAliasesSuperType(properties.getTypeAliasesSuperType());
        }
        if (StringUtils.hasLength((String)properties.getTypeHandlersPackage())) {
            sqlSessionFactoryBean.setTypeHandlersPackage(properties.getTypeHandlersPackage());
        }
        if (!ObjectUtils.isEmpty(typeHandlers = this.getBeanFactory().getBeanProvider(TypeHandler.class).orderedStream().collect(Collectors.toList()))) {
            sqlSessionFactoryBean.setTypeHandlers(typeHandlers.toArray(new TypeHandler[0]));
        }
        if (!ObjectUtils.isEmpty((Object[])properties.resolveMapperLocations())) {
            sqlSessionFactoryBean.setMapperLocations(properties.resolveMapperLocations());
        }
        Set factoryPropertyNames = Stream.of(new BeanWrapperImpl(SqlSessionFactoryBean.class).getPropertyDescriptors()).map(FeatureDescriptor::getName).collect(Collectors.toSet());
        Class<?> defaultLanguageDriver = properties.getDefaultScriptingLanguageDriver();
        List<LanguageDriver> languageDrivers = this.getAgreedNamingBeans(database, LanguageDriver.class);
        if (factoryPropertyNames.contains("scriptingLanguageDrivers") && !ObjectUtils.isEmpty(languageDrivers)) {
            sqlSessionFactoryBean.setScriptingLanguageDrivers(languageDrivers.toArray(new LanguageDriver[0]));
            if (defaultLanguageDriver == null && languageDrivers.size() == 1) {
                defaultLanguageDriver = languageDrivers.get(0).getClass();
            }
        }
        if (factoryPropertyNames.contains("defaultScriptingLanguageDriver")) {
            sqlSessionFactoryBean.setDefaultScriptingLanguageDriver((Class)defaultLanguageDriver);
        }
        return sqlSessionFactoryBean;
    }

    protected void applyConfiguration(SqlSessionFactoryBean sqlSessionFactoryBean, String database, MybatisProperties properties) {
        Resource configLocationResource = this.getConfigLocation(properties.getConfigLocation());
        sqlSessionFactoryBean.setConfigLocation(configLocationResource);
        Configuration configuration = properties.getConfiguration();
        if (configuration == null && configLocationResource == null) {
            configuration = new Configuration();
            configuration.setMapUnderscoreToCamelCase(true);
        }
        List<ConfigurationCustomizer> configurationCustomizers = this.getAgreedNamingBeans(database, ConfigurationCustomizer.class);
        if (configuration != null && !CollectionUtils.isEmpty(configurationCustomizers)) {
            for (ConfigurationCustomizer customizer : configurationCustomizers) {
                customizer.customize(configuration);
            }
        }
        sqlSessionFactoryBean.setConfiguration(configuration);
    }
}

