/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mds.mybatis;

import org.springframework.boot.autoconfigure.mds.NamedDatabase;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.filter.AbstractTypeHierarchyTraversingFilter;
import org.springframework.util.ClassUtils;

public class DatabasedMapperExcludeFilter
extends AbstractTypeHierarchyTraversingFilter {
    private final String targetDatabase;

    protected DatabasedMapperExcludeFilter(String targetDatabase) {
        super(true, true);
        this.targetDatabase = targetDatabase;
    }

    protected boolean matchSelf(MetadataReader metadataReader) {
        AnnotationMetadata annotationMetadata = metadataReader.getAnnotationMetadata();
        return annotationMetadata.getAnnotations().stream(NamedDatabase.class).noneMatch(mergedAnotation -> this.targetDatabase.equals(mergedAnotation.getString("value")));
    }

    protected Boolean matchSuperClass(String superClassName) {
        return this.matchDatabase(superClassName);
    }

    protected Boolean matchInterface(String interfaceName) {
        return this.matchDatabase(interfaceName);
    }

    protected Boolean matchDatabase(String typeName) {
        try {
            Class clazz = ClassUtils.forName((String)typeName, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            NamedDatabase[] namedDatabases = (NamedDatabase[])clazz.getAnnotationsByType(NamedDatabase.class);
            if (namedDatabases.length > 0) {
                for (NamedDatabase namedDatabase : namedDatabases) {
                    if (!this.targetDatabase.equals(namedDatabase.value())) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

