/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mds.jdbc;

import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.mds.MdsComponentType;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionManager;

public enum MdsJdbcComponentType implements MdsComponentType
{
    DATASOURCE_PROPERTIES(DataSourceProperties.class),
    DATASOURCE(DataSource.class),
    JDBC_TEMPLATE(JdbcTemplate.class),
    TRANSACTION_MANAGER((Class)DataSourceTransactionManager.class){

        @Override
        public String getComponentBeanName(String database) {
            return MdsComponentType.getComponentBeanName(database, TransactionManager.class);
        }
    };

    private final Class<?> componentBeanType;

    private MdsJdbcComponentType(Class<?> componentBeanType) {
        this.componentBeanType = componentBeanType;
    }

    @Override
    public <T> Class<T> getComponentBeanType() {
        return this.componentBeanType;
    }
}

