/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mds.jdbc;

import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.JdbcProperties;
import org.springframework.boot.autoconfigure.mds.MdsComponentConfig;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public enum MdsJdbcComponentConfig implements MdsComponentConfig
{
    DATASOURCE("spring.datasource", (Class)DataSourceProperties.class){

        public DataSourceProperties getBoundedConfigProperties(Environment environment, String database) {
            String configPrefix;
            DataSourceProperties configProperties;
            if (StringUtils.hasText((String)database) && (StringUtils.hasText((String)(configProperties = (DataSourceProperties)this.bindConfigProperties(environment, configPrefix = this.getConfigPrefix() + "." + database)).getJndiName()) || StringUtils.hasText((String)configProperties.getUrl()) && StringUtils.hasText((String)configProperties.getUsername()) && StringUtils.hasText((String)configProperties.getPassword()))) {
                return configProperties;
            }
            return null;
        }

        public DataSourceProperties newDefaultConfigProperties() {
            return new DataSourceProperties();
        }
    }
    ,
    JDBC("spring.jdbc", (Class)JdbcProperties.class){

        public JdbcProperties getBoundedConfigProperties(Environment environment, String database) {
            return (JdbcProperties)this.bindConfigProperties(environment, this.getConfigPrefix());
        }

        public JdbcProperties newDefaultConfigProperties() {
            return new JdbcProperties();
        }
    };

    private final String configPrefix;
    private final Class<?> configPropertiesType;

    private MdsJdbcComponentConfig(String configPrefix, Class<?> configPropertiesType) {
        this.configPrefix = configPrefix;
        this.configPropertiesType = configPropertiesType;
    }

    @Override
    public String getConfigPrefix() {
        return this.configPrefix;
    }

    @Override
    public Class<?> getConfigPropertiesType() {
        return this.configPropertiesType;
    }
}

