/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mds;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.mds.MdsComponentType;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.support.JmxUtils;

public abstract class MdsComponentsBuilderSupport
implements ApplicationContextAware,
EnvironmentAware,
ResourceLoaderAware,
BeanFactoryAware {
    private ConfigurableApplicationContext applicationContext;
    private ConfigurableEnvironment environment;
    private ConfigurableListableBeanFactory beanFactory;
    private ResourceLoader resourceLoader;

    protected <T> List<T> getAgreedNamingBeans(String database, Class<T> beanClass) {
        ArrayList candidateBeans = new ArrayList();
        Map beanMaps = this.getBeanFactory().getBeansOfType(beanClass);
        for (Map.Entry entry : beanMaps.entrySet()) {
            String realBeanName = (String)entry.getKey();
            Object beanInstance = entry.getValue();
            String agreedBeanName = MdsComponentType.getComponentBeanName(database, beanInstance.getClass());
            if (!agreedBeanName.equals(realBeanName)) continue;
            candidateBeans.add(beanInstance);
        }
        return candidateBeans;
    }

    protected <T> T getAgreedNamingBean(String database, Class<T> beanClass) {
        String agreedBeanName = MdsComponentType.getComponentBeanName(database, beanClass);
        try {
            return (T)this.getBeanFactory().getBean(agreedBeanName, beanClass);
        }
        catch (BeansException e) {
            return null;
        }
    }

    protected void excludeMBeanIfNecessary(Object candidate, String beanName) {
        for (MBeanExporter mbeanExporter : this.applicationContext.getBeansOfType(MBeanExporter.class).values()) {
            if (!JmxUtils.isMBean(candidate.getClass())) continue;
            mbeanExporter.addExcludedBean(beanName);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public final void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    public final void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public final void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    protected ConfigurableEnvironment getEnvironment() {
        return this.environment;
    }

    protected ListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }
}

