/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mds;

import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.mds.AbstractMdsComponentsRegistry;
import org.springframework.boot.autoconfigure.mds.MdsComponentBeans;
import org.springframework.boot.autoconfigure.mds.MdsComponentsRegistrationLifecycle;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.CollectionUtils;

class MdsComponentRegistrar
implements ImportBeanDefinitionRegistrar,
BeanFactoryAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(MdsComponentRegistrar.class);
    private ListableBeanFactory beanFactory;

    MdsComponentRegistrar() {
    }

    public void registerBeanDefinitions(AnnotationMetadata mdsAnnotationMetadata, BeanDefinitionRegistry registry) {
        List dsComponentsRegistries = this.beanFactory.getBeanProvider(AbstractMdsComponentsRegistry.class).orderedStream().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(dsComponentsRegistries)) {
            List<MdsComponentsRegistrationLifecycle> mdsComponentsRegistrationLifecycles = this.getMdsComponentsRegistrationLifecycles();
            mdsComponentsRegistrationLifecycles.forEach(listener -> listener.beforeMdsComponentsRegistered(mdsAnnotationMetadata, registry));
            MdsComponentBeans mdsComponentBeans = new MdsComponentBeans();
            for (AbstractMdsComponentsRegistry mdsComponentsRegistry : dsComponentsRegistries) {
                mdsComponentsRegistry.registerBeanDefinitions(mdsAnnotationMetadata, registry, mdsComponentBeans);
            }
            if (mdsComponentBeans.getDefaultTransactionManager() != null) {
                LOGGER.info("Dynamic register all multi-datasource components successfully : {}", (Object)mdsComponentBeans);
            }
            mdsComponentsRegistrationLifecycles.forEach(listener -> listener.afterMdsComponentsRegistered(mdsAnnotationMetadata, registry, mdsComponentBeans.clone()));
        }
    }

    protected List<MdsComponentsRegistrationLifecycle> getMdsComponentsRegistrationLifecycles() {
        return this.beanFactory.getBeanProvider(MdsComponentsRegistrationLifecycle.class).orderedStream().collect(Collectors.toList());
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }
}

