/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mds;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.autoconfigure.mds.MdsComponentType;
import org.springframework.util.StringUtils;

public class DatabasedBeanNameGenerator
implements BeanNameGenerator {
    private final String targetDatabase;

    public DatabasedBeanNameGenerator(String targetDatabase) {
        this.targetDatabase = targetDatabase;
    }

    public String generateBeanName(BeanDefinition definition, BeanDefinitionRegistry registry) {
        GenericBeanDefinition genericBeanDefinition = (GenericBeanDefinition)definition;
        String beanClassName = genericBeanDefinition.getBeanClassName();
        if (!StringUtils.hasText((String)beanClassName)) {
            beanClassName = genericBeanDefinition.getBeanClass().getName();
        }
        return MdsComponentType.getComponentBeanName(this.targetDatabase, beanClassName);
    }
}

