/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.tinyloki;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import pl.mjaron.tinyloki.ILogCollector;
import pl.mjaron.tinyloki.ILogStream;
import pl.mjaron.tinyloki.JsonLogStream;
import pl.mjaron.tinyloki.Labels;

public class JsonLogCollector
implements ILogCollector {
    public static final String CONTENT_TYPE = "application/json";
    private final List<JsonLogStream> streams = new ArrayList<JsonLogStream>();
    private int logEntriesCount = 0;
    private final Object logEntriesLock = new Object();

    @Override
    public synchronized ILogStream createStream(Labels labels) {
        JsonLogStream stream = new JsonLogStream(this, labels);
        this.streams.add(stream);
        return stream;
    }

    public synchronized void onStreamReleased(ILogStream stream) {
        this.streams.remove((JsonLogStream)stream);
    }

    @Override
    public byte[] collect() {
        String collectedAsString = this.collectAsString();
        if (collectedAsString == null) {
            return null;
        }
        return collectedAsString.getBytes(StandardCharsets.UTF_8);
    }

    public synchronized String collectAsString() {
        StringBuilder b = new StringBuilder("{\"streams\":[");
        boolean isFirst = true;
        boolean anyStreamNotEmpty = false;
        for (JsonLogStream stream : this.streams) {
            String streamData = stream.flush();
            if (streamData == null) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                b.append(',');
            }
            b.append(streamData);
            anyStreamNotEmpty = true;
        }
        if (!anyStreamNotEmpty) {
            return null;
        }
        b.append("]}");
        return b.toString();
    }

    @Override
    public String contentType() {
        return CONTENT_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logOccurred() {
        Object object = this.logEntriesLock;
        synchronized (object) {
            ++this.logEntriesCount;
            this.logEntriesLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitForLogs(long timeout) throws InterruptedException {
        Object object = this.logEntriesLock;
        synchronized (object) {
            if (this.logEntriesCount == 0) {
                this.logEntriesLock.wait(timeout);
            }
            int logEntriesCountCopy = this.logEntriesCount;
            this.logEntriesCount = 0;
            return logEntriesCountCopy;
        }
    }
}

