/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.tinyloki;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import pl.mjaron.tinyloki.ILogMonitor;
import pl.mjaron.tinyloki.ILogSender;
import pl.mjaron.tinyloki.LogSenderSettings;
import pl.mjaron.tinyloki.third_party.Base64Coder;

public class HttpLogSender
implements ILogSender {
    private LogSenderSettings settings;
    private ILogMonitor logMonitor;
    private URL url;

    @Override
    public void configure(LogSenderSettings logSenderSettings, ILogMonitor logMonitor) {
        this.settings = logSenderSettings;
        this.logMonitor = logMonitor;
        try {
            this.url = new URL(this.settings.getUrl());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to initialize URL with: [" + this.settings.getUrl() + "].", e);
        }
    }

    @Override
    public void send(byte[] message) {
        block49: {
            IOException e2;
            block50: {
                this.logMonitor.send(message);
                HttpURLConnection connection = null;
                try {
                    Object authHeaderEncoded;
                    connection = (HttpURLConnection)this.url.openConnection();
                    connection.setDoOutput(true);
                    connection.setDoInput(true);
                    connection.setConnectTimeout(this.settings.getConnectTimeout());
                    connection.setRequestMethod("POST");
                    connection.setRequestProperty("Content-Type", this.settings.getContentType());
                    if (this.settings.getContentEncoding() != null) {
                        connection.setRequestProperty("Content-Encoding", this.settings.getContentEncoding());
                    }
                    connection.setRequestProperty("Content-Length", Integer.toString(message.length));
                    if (this.settings.getUser() != null && this.settings.getPassword() != null) {
                        String authHeaderContentString = this.settings.getUser() + ":" + this.settings.getPassword();
                        authHeaderEncoded = Base64Coder.encodeString(authHeaderContentString);
                        connection.setRequestProperty("Authorization", "Basic " + (String)authHeaderEncoded);
                    }
                    OutputStream outputStream = connection.getOutputStream();
                    authHeaderEncoded = null;
                    try {
                        outputStream.write(message);
                    }
                    catch (Throwable throwable) {
                        authHeaderEncoded = throwable;
                        throw throwable;
                    }
                    finally {
                        if (outputStream != null) {
                            if (authHeaderEncoded != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)authHeaderEncoded).addSuppressed(throwable);
                                }
                            } else {
                                outputStream.close();
                            }
                        }
                    }
                    InputStream inputStream = connection.getInputStream();
                    authHeaderEncoded = null;
                    try {
                        while (inputStream.read() != -1) {
                        }
                    }
                    catch (Throwable throwable) {
                        authHeaderEncoded = throwable;
                        throw throwable;
                    }
                    finally {
                        if (inputStream != null) {
                            if (authHeaderEncoded != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)authHeaderEncoded).addSuppressed(throwable);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                    }
                    int responseCode = connection.getResponseCode();
                    if (responseCode != 200 && responseCode != 204) {
                        String responseMessage = connection.getResponseMessage();
                        this.logMonitor.sendErr(responseCode, responseMessage);
                    } else {
                        this.logMonitor.sendOk(responseCode);
                    }
                    break block49;
                }
                catch (IOException e2) {
                    if (connection == null) break block50;
                    try (InputStream errorStream = connection.getErrorStream();){
                        if (errorStream != null) {
                            while (errorStream.read() != -1) {
                            }
                        }
                    }
                    catch (IOException e22) {
                        e22.printStackTrace();
                    }
                }
            }
            throw new RuntimeException("Failed to send logs.", e2);
        }
    }
}

