/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.network.sdk;

import android.content.Context;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import com.kwai.network.sdk.annotations.KsAdSdkApi;
import com.kwai.network.sdk.annotations.KwaiAdSdkApi;
import com.kwai.network.sdk.api.KwaiAdLoaderManager;
import com.kwai.network.sdk.api.KwaiInitCallback;
import com.kwai.network.sdk.api.SdkConfig;
import com.kwai.network.sdk.constant.ErrorCode;
import com.kwai.network.sdk.core.IKwaiAdSDK;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;

@KwaiAdSdkApi
@Keep
public class KwaiAdSDK {
    private static final String TAG = "KwaiAdSDK";
    private static final AtomicBoolean sHasInit = new AtomicBoolean(false);
    private static IKwaiAdSDK mKwaiAdSDK;

    @MainThread
    public static synchronized void init(Context context, final SdkConfig config) {
        try {
            if (null == context || null == config || config.isInvalid()) {
                if (null != config) {
                    config.ksInitCallback.onFail(ErrorCode.ERROR_CODE_INIT_PARAMS_INVALID, "context or config is isInvalid");
                }
                return;
            }
            if (sHasInit.get()) {
                config.ksInitCallback.onFail(ErrorCode.ERROR_CODE_INIT_RECALL, "sdk already initialized");
                return;
            }
            mKwaiAdSDK = KwaiAdSDK.getKwaiAdSDKImpl(KwaiAdSDK.class.getClassLoader());
            mKwaiAdSDK.init(context, config, new KwaiInitCallback(){

                @Override
                public void onSuccess() {
                    sHasInit.set(true);
                    config.ksInitCallback.onSuccess();
                }

                @Override
                public void onFail(int code, String msg) {
                    config.ksInitCallback.onFail(code, msg);
                }
            });
        }
        catch (Throwable e) {
            config.ksInitCallback.onFail(ErrorCode.ERROR_CODE_INIT_MAIN_PROCESS, "init error. " + (e == null ? "" : e.toString()));
        }
    }

    @MainThread
    @NonNull
    static synchronized IKwaiAdSDK getKwaiAdSDKImpl(ClassLoader loader) {
        try {
            KsAdSdkApi annotation = IKwaiAdSDK.class.getAnnotation(KsAdSdkApi.class);
            assert (annotation != null);
            String implClassName = annotation.value();
            Class<?> implClass = Class.forName(implClassName, true, loader);
            Method get = implClass.getDeclaredMethod("get", new Class[0]);
            Object sdk = get.invoke(null, new Object[0]);
            if (sdk == null) {
                throw new RuntimeException("Can not get sdk form " + loader);
            }
            return (IKwaiAdSDK)sdk;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @KwaiAdSdkApi
    @Keep
    public static KwaiAdLoaderManager getKwaiAdLoaderManager() {
        if (!sHasInit.get() || mKwaiAdSDK == null) {
            Log.e((String)TAG, (String)"Can not obtain KwaiAdRequestManager.SDK init failed.");
            return null;
        }
        return mKwaiAdSDK.getAdManager();
    }

    @KwaiAdSdkApi
    @Keep
    public static boolean isDebugLogEnable() {
        if (!sHasInit.get() || mKwaiAdSDK == null) {
            return false;
        }
        return mKwaiAdSDK.isDebugLogEnable();
    }

    @KwaiAdSdkApi
    @Keep
    public static String getAppId() {
        if (!sHasInit.get() || mKwaiAdSDK == null) {
            return "";
        }
        return mKwaiAdSDK.getAppId();
    }

    @KwaiAdSdkApi
    @Keep
    public static String getAppName() {
        if (!sHasInit.get() || mKwaiAdSDK == null) {
            return "";
        }
        return mKwaiAdSDK.getAppName();
    }

    @KwaiAdSdkApi
    @Keep
    public static int getSDKVersionCode() {
        if (!sHasInit.get() || mKwaiAdSDK == null) {
            return 0;
        }
        return mKwaiAdSDK.getSDKVersionCode();
    }

    @KwaiAdSdkApi
    @Keep
    public static String getSDKVersion() {
        if (!sHasInit.get() || mKwaiAdSDK == null) {
            return "";
        }
        return mKwaiAdSDK.getSDKVersion();
    }

    @KsAdSdkApi
    @Keep
    public static String getDid() {
        if (!sHasInit.get() || mKwaiAdSDK == null) {
            return "";
        }
        return mKwaiAdSDK.getDid();
    }
}

